/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CreateStoreRequest {
    private final String name;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    CreateStoreRequest(String name) {
        this.name = Preconditions.parameterNonNull(name, "name");
    }

    public static CreateStoreRequest of(String name) {
        return new CreateStoreRequest(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CreateStoreRequest that = (CreateStoreRequest)obj;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "CreateStoreRequest[name=" + this.name + "]";
    }

    public static final class Builder {
        private String name;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public CreateStoreRequest build() {
            return new CreateStoreRequest(this.name);
        }
    }
}

