/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.Metadata;
import io.quarkiverse.openfga.client.model.Userset;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TypeDefinition {
    private final String type;
    @Nullable
    private final Map<String, Userset> relations;
    @Nullable
    private final Metadata metadata;

    @JsonCreator
    TypeDefinition(String type, @Nullable Map<String, Userset> relations, @Nullable Metadata metadata) {
        this.type = Preconditions.parameterNonNull(type, "type");
        this.relations = relations;
        this.metadata = metadata;
    }

    public static TypeDefinition of(String type, @Nullable Map<String, Userset> relations, @Nullable Metadata metadata) {
        return new TypeDefinition(type, relations, metadata);
    }

    public static TypeDefinition of(String type, @Nullable Map<String, Userset> relations) {
        return TypeDefinition.of(type, relations, null);
    }

    public static TypeDefinition of(String type) {
        return TypeDefinition.of(type, null, null);
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public Map<String, Userset> getRelations() {
        return this.relations;
    }

    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition that = (TypeDefinition)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.relations, that.relations) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.relations, this.metadata);
    }

    public String toString() {
        return "TypeDefinition{type='" + this.type + "', relations=" + this.relations + ", metadata=" + this.metadata + "}";
    }
}

