/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.ConditionalTupleKey;
import io.quarkiverse.openfga.client.model.TupleOperation;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TupleChange {
    private final ConditionalTupleKey tupleKey;
    private final TupleOperation operation;
    private final OffsetDateTime timestamp;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    TupleChange(@JsonProperty(value="tuple_key") ConditionalTupleKey tupleKey, TupleOperation operation, OffsetDateTime timestamp) {
        this.tupleKey = Preconditions.parameterNonNull(tupleKey, "tupleKey");
        this.operation = Preconditions.parameterNonNull(operation, "operation");
        this.timestamp = Preconditions.parameterNonNull(timestamp, "timestamp");
    }

    public static TupleChange of(ConditionalTupleKey tupleKey, TupleOperation operation, OffsetDateTime timestamp) {
        return new TupleChange(tupleKey, operation, timestamp);
    }

    @JsonProperty(value="tuple_key")
    public ConditionalTupleKey getTupleKey() {
        return this.tupleKey;
    }

    public TupleOperation getOperation() {
        return this.operation;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TupleChange that = (TupleChange)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && Objects.equals((Object)this.operation, (Object)that.operation) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.operation, this.timestamp});
    }

    public String toString() {
        return "TupleChange[tupleKey=" + this.tupleKey + ", operation=" + this.operation + ", timestamp=" + this.timestamp + "]";
    }
}

