/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ObjectRelation {
    @Nullable
    private final String object;
    private final String relation;

    @JsonCreator
    ObjectRelation(@Nullable String object, String relation) {
        this.object = object;
        this.relation = Preconditions.parameterNonNull(relation, "relation");
    }

    public static ObjectRelation of(@Nullable String object, String relation) {
        return new ObjectRelation(object, relation);
    }

    public static ObjectRelation of(String relation) {
        return ObjectRelation.of(null, relation);
    }

    @Nullable
    public String getObject() {
        return this.object;
    }

    public String getRelation() {
        return this.relation;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ObjectRelation that = (ObjectRelation)obj;
        return Objects.equals(this.object, that.object) && Objects.equals(this.relation, that.relation);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.relation);
    }

    public String toString() {
        return "ObjectRelation[object=" + this.object + ", relation=" + this.relation + "]";
    }
}

