/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.ConditionalTupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ConditionalTupleKeys {
    private final List<ConditionalTupleKey> tupleKeys;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    ConditionalTupleKeys(@JsonProperty(value="tuple_keys") List<ConditionalTupleKey> tupleKeys) {
        if (tupleKeys.isEmpty()) {
            throw new IllegalStateException("tupleKeys requires a minimum of 1 item");
        }
        this.tupleKeys = Preconditions.parameterNonNull(tupleKeys, "tupleKeys");
    }

    public static ConditionalTupleKeys of(@Nullable List<ConditionalTupleKey> tupleKeys) {
        if (tupleKeys == null || tupleKeys.isEmpty()) {
            return null;
        }
        return new ConditionalTupleKeys(tupleKeys);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="tuple_keys")
    public List<ConditionalTupleKey> getTupleKeys() {
        return this.tupleKeys;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConditionalTupleKeys that = (ConditionalTupleKeys)obj;
        return Objects.equals(this.tupleKeys, that.tupleKeys);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKeys);
    }

    public String toString() {
        return "TupleKeys[tupleKeys=" + this.tupleKeys + "]";
    }

    public static final class Builder {
        private List<ConditionalTupleKey> tupleKeys;

        public Builder tupleKeys(@Nullable List<ConditionalTupleKey> tupleKeys) {
            this.tupleKeys = tupleKeys;
            return this;
        }

        public Builder add(ConditionalTupleKey tupleKey) {
            if (this.tupleKeys == null) {
                this.tupleKeys = new ArrayList<ConditionalTupleKey>();
            }
            this.tupleKeys.add(tupleKey);
            return this;
        }

        public ConditionalTupleKeys build() {
            return new ConditionalTupleKeys(this.tupleKeys);
        }
    }
}

