/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.quarkiverse.openfga.client.model.Assertion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Assertions {
    private final List<Assertion> assertions;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    Assertions(List<Assertion> assertions) {
        this.assertions = assertions;
    }

    public static Assertions of(List<Assertion> assertions) {
        return new Assertions(assertions);
    }

    public List<Assertion> getAssertions() {
        return this.assertions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Assertions that = (Assertions)obj;
        return this.assertions.equals(that.assertions);
    }

    public int hashCode() {
        return Objects.hash(this.assertions);
    }

    public String toString() {
        return "Assertions[assertions=" + this.assertions + "]";
    }

    public static final class Builder {
        private List<Assertion> assertions;

        public Builder assertions(List<Assertion> assertions) {
            this.assertions = assertions;
            return this;
        }

        public Builder addAssertions(List<Assertion> assertions) {
            if (this.assertions == null) {
                this.assertions = new ArrayList<Assertion>();
            }
            this.assertions.addAll(assertions);
            return this;
        }

        public Builder addAssertion(Assertion assertion) {
            if (this.assertions == null) {
                this.assertions = new ArrayList<Assertion>();
            }
            this.assertions.add(assertion);
            return this;
        }

        public Assertions build() {
            return new Assertions(this.assertions);
        }
    }
}

