/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Tuple {
    private final TupleKey key;
    private final OffsetDateTime timestamp;

    public Tuple(TupleKey key, OffsetDateTime timestamp) {
        this.key = Preconditions.parameterNonNull(key, "key");
        this.timestamp = Preconditions.parameterNonNull(timestamp, "timestamp");
    }

    public TupleKey getKey() {
        return this.key;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Tuple that = (Tuple)obj;
        return Objects.equals(this.key, that.key) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.timestamp);
    }

    public String toString() {
        return "Tuple[key=" + this.key + ", timestamp=" + this.timestamp + "]";
    }
}

