/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Objects;
import javax.annotation.Nullable;

public class RelationReference {
    String type;
    @Nullable
    String relation;
    @Nullable
    Object wildcard;
    @Nullable
    String condition;

    @JsonCreator
    public RelationReference(String type, @Nullable String relation, @Nullable Object wildcard, @Nullable String condition) {
        this.type = type;
        this.relation = relation;
        this.wildcard = wildcard;
        this.condition = condition;
    }

    public RelationReference(String type) {
        this(type, null, null, null);
    }

    public RelationReference(String type, String relation) {
        this(type, relation, null, null);
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public String getRelation() {
        return this.relation;
    }

    @Nullable
    public Object getWildcard() {
        return this.wildcard;
    }

    @Nullable
    public String getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationReference)) {
            return false;
        }
        RelationReference that = (RelationReference)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.relation, that.relation) && Objects.equals(this.wildcard, that.wildcard) && Objects.equals(this.condition, that.condition);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.relation, this.wildcard, this.condition);
    }

    public String toString() {
        return "RelationReference{type='" + this.type + "', relation='" + this.relation + "', wildcard=" + this.wildcard + "', condition='" + this.condition + "'}";
    }
}

