/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model.nodes;

import io.quarkiverse.openfga.client.model.nodes.Difference;
import io.quarkiverse.openfga.client.model.nodes.Leaf;
import io.quarkiverse.openfga.client.model.nodes.Nodes;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Node {
    private final String name;
    @Nullable
    private final Leaf leaf;
    @Nullable
    private final Difference difference;
    @Nullable
    private final Nodes union;
    @Nullable
    private final Nodes intersection;

    public Node(String name, @Nullable Leaf leaf, @Nullable Difference difference, @Nullable Nodes union, @Nullable Nodes intersection) {
        this.name = Preconditions.parameterNonNull(name, "name");
        this.leaf = leaf;
        this.difference = difference;
        this.union = union;
        this.intersection = intersection;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Leaf getLeaf() {
        return this.leaf;
    }

    @Nullable
    public Difference getDifference() {
        return this.difference;
    }

    @Nullable
    public Nodes getUnion() {
        return this.union;
    }

    @Nullable
    public Nodes getIntersection() {
        return this.intersection;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Node that = (Node)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.leaf, that.leaf) && Objects.equals(this.difference, that.difference) && Objects.equals(this.union, that.union) && Objects.equals(this.intersection, that.intersection);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.leaf, this.difference, this.union, this.intersection);
    }

    public String toString() {
        return "Node[name=" + this.name + ", leaf=" + this.leaf + ", difference=" + this.difference + ", union=" + this.union + ", intersection=" + this.intersection + "]";
    }
}

