/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.TypeDefinition;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TypeDefinitions {
    @JsonProperty(value="schema_version")
    @Nullable
    private final String schemaVersion;
    @JsonProperty(value="type_definitions")
    private final List<TypeDefinition> typeDefinitions;

    @JsonCreator
    public TypeDefinitions(@JsonProperty(value="schema_version") @Nullable String schemaVersion, @JsonProperty(value="type_definitions") List<TypeDefinition> typeDefinitions) {
        this.schemaVersion = schemaVersion;
        this.typeDefinitions = Preconditions.parameterNonNull(typeDefinitions, "typeDefinitions");
    }

    public TypeDefinitions(@JsonProperty(value="type_definitions") List<TypeDefinition> typeDefinitions) {
        this.schemaVersion = null;
        this.typeDefinitions = Preconditions.parameterNonNull(typeDefinitions, "typeDefinitions");
    }

    @JsonProperty(value="schema_version")
    @Nullable
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="type_definitions")
    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinitions)) {
            return false;
        }
        TypeDefinitions that = (TypeDefinitions)o;
        return Objects.equals(this.schemaVersion, that.schemaVersion) && Objects.equals(this.typeDefinitions, that.typeDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.typeDefinitions);
    }

    public String toString() {
        return "TypeDefinitions{schemaVersion='" + this.schemaVersion + "', typeDefinitions=" + this.typeDefinitions + "}";
    }
}

