/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.Condition;
import io.quarkiverse.openfga.client.model.TypeDefinition;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AuthorizationModel {
    private final String id;
    private final String schemaVersion;
    private final List<TypeDefinition> typeDefinitions;
    @Nullable
    private final Map<String, Condition> conditions;

    public AuthorizationModel(String id, @JsonProperty(value="schema_version") String schemaVersion, @JsonProperty(value="type_definitions") List<TypeDefinition> typeDefinitions, @JsonProperty(value="conditions") @Nullable Map<String, Condition> conditions) {
        this.id = Preconditions.parameterNonNull(id, "id");
        this.schemaVersion = Preconditions.parameterNonNull(schemaVersion, "schemaVersion");
        this.typeDefinitions = Preconditions.parameterNonNull(typeDefinitions, "typeDefinitions");
        this.conditions = conditions;
    }

    public String getId() {
        return this.id;
    }

    @JsonProperty(value="schema_version")
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @JsonProperty(value="type_definitions")
    public List<TypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    @JsonProperty(value="conditions")
    @Nullable
    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AuthorizationModel that = (AuthorizationModel)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.typeDefinitions, that.typeDefinitions) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.typeDefinitions, this.conditions);
    }

    public String toString() {
        return "AuthorizationModel[id=" + this.id + ", typeDefinitions=" + this.typeDefinitions + ", conditions=" + this.conditions + "]";
    }
}

