/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.utils.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Assertion {
    private final TupleKey tupleKey;
    private final boolean expectation;

    public Assertion(@JsonProperty(value="tuple_key") TupleKey tupleKey, boolean expectation) {
        this.tupleKey = Preconditions.parameterNonNull(tupleKey, "tupleKey");
        this.expectation = expectation;
    }

    @JsonProperty(value="tuple_key")
    public TupleKey getTupleKey() {
        return this.tupleKey;
    }

    public boolean getExpectation() {
        return this.expectation;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Assertion that = (Assertion)obj;
        return Objects.equals(this.tupleKey, that.tupleKey) && this.expectation == that.expectation;
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.expectation);
    }

    public String toString() {
        return "Assertion[tupleKey=" + this.tupleKey + ", expectation=" + this.expectation + "]";
    }
}

