/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.deployment;

import io.quarkiverse.openfga.client.AuthorizationModelsClient;
import io.quarkiverse.openfga.client.OpenFGAClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.api.VertxWebClientFactory;
import io.quarkiverse.openfga.client.api.auth.CredentialsProvider;
import io.quarkiverse.openfga.client.api.auth.PresharedKeyCredentialsProvider;
import io.quarkiverse.openfga.client.api.auth.UnauthenticatedCredentialsProvider;
import io.quarkiverse.openfga.client.model.AuthorizationModel;
import io.quarkiverse.openfga.client.model.AuthorizationModelSchema;
import io.quarkiverse.openfga.client.model.RelTupleKeyed;
import io.quarkiverse.openfga.client.model.RelTupleKeys;
import io.quarkiverse.openfga.client.model.Store;
import io.quarkiverse.openfga.client.model.dto.CreateStoreRequest;
import io.quarkiverse.openfga.client.model.dto.CreateStoreResponse;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelRequest;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelResponse;
import io.quarkiverse.openfga.client.model.dto.WriteRequest;
import io.quarkiverse.openfga.deployment.DevServicesOpenFGAConfig;
import io.quarkiverse.openfga.deployment.OpenFGABuildTimeConfig;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.core.Vertx;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.openfga.OpenFGAContainer;
import org.testcontainers.utility.DockerImageName;

public class DevServicesOpenFGAProcessor {
    private static final Logger log = Logger.getLogger(DevServicesOpenFGAProcessor.class);
    static final String OPEN_FGA_VERSION = "v1.8.4";
    static final String OPEN_FGA_IMAGE = "openfga/openfga:v1.8.4";
    static final int OPEN_FGA_EXPOSED_HTTP_PORT = 8080;
    static final int OPEN_FGA_EXPOSED_GRPC_PORT = 8081;
    static final int OPEN_FGA_EXPOSED_PLAY_PORT = 3000;
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-openfga";
    static final String CONFIG_PREFIX = "quarkus.openfga.";
    static final String URL_CONFIG_KEY = "quarkus.openfga.url";
    static final String STORE_ID_CONFIG_KEY = "quarkus.openfga.store";
    static final String AUTHORIZATION_MODEL_ID_CONFIG_KEY = "quarkus.openfga.authorization-model-id";
    static final String CREDS_PREFIX = "quarkus.openfga.credentials.";
    static final String CREDS_METHOD_KEY = "quarkus.openfga.credentials.method";
    static final String CREDS_PRESHARED_PREFIX = "quarkus.openfga.credentials.preshared.";
    static final String CREDS_PRESHARED_KEY_KEY = "quarkus.openfga.credentials.preshared.key";
    static final String CREDS_OIDC_PREFIX = "quarkus.openfga.credentials.oidc.";
    static final String CREDS_OIDC_ISSUER_KEY = "quarkus.openfga.credentials.oidc.issuer";
    static final String CREDS_OIDC_AUDIENCE_KEY = "quarkus.openfga.credentials.oidc.audience";
    static final String DEVSERVICES_PREFIX = "quarkus.devservices.";
    static final String AUTHN_PREFIX = "quarkus.devservices.openfga.";
    static final String AUTHN_PRESHARED_PREFIX = "quarkus.devservices.openfga.authn.preshared.";
    static final String AUTHN_PRESHARED_KEYS_KEY = "quarkus.devservices.openfga.authn.preshared.keys";
    static final ContainerLocator openFGAContainerLocator = new ContainerLocator("quarkus-dev-service-openfga", 8080);
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static volatile DevServicesOpenFGAConfig capturedDevServicesConfiguration;
    private static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startContainers(OpenFGABuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig, BuildProducer<DevServicesResultBuildItem> devServicesResults) {
        block12: {
            DevServicesOpenFGAConfig currentDevServicesConfiguration = config.devservices();
            if (devService != null) {
                boolean restartRequired;
                boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
                if (!restartRequired) {
                    return devService.toBuildItem();
                }
                try {
                    devService.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop OpenFGA container", e);
                }
                devService = null;
                capturedDevServicesConfiguration = null;
            }
            capturedDevServicesConfiguration = currentDevServicesConfiguration;
            try (StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "OpenFGA Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);){
                devService = this.startContainer(dockerStatusBuildItem, currentDevServicesConfiguration, launchMode, devServicesConfig.timeout());
                if (devService != null) {
                    if (devService.isOwner()) {
                        log.info((Object)"Dev Services for OpenFGA started.");
                        log.infof("Other Quarkus applications in dev mode will find the instance automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -D%s=%s", (Object)URL_CONFIG_KEY, devService.getConfig().get(URL_CONFIG_KEY));
                    }
                    break block12;
                }
                DevServicesResultBuildItem e = null;
                return e;
            }
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    try {
                        devService.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)"Failed to stop OpenFGA container", t);
                    }
                    devService = null;
                    log.info((Object)"Dev Services for OpenFGA shut down.");
                }
                first = true;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        return devService.toBuildItem();
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, DevServicesOpenFGAConfig devConfig, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devConfig.enabled().orElse(true).booleanValue()) {
            log.debug((Object)"Not starting devservices for OpenFGA as it has been disabled in the config");
            return null;
        }
        boolean bl = needToStart = !ConfigUtils.isPropertyNonEmpty((String)URL_CONFIG_KEY);
        if (!needToStart) {
            log.debug((Object)"Not starting devservices for default OpenFGA client as url has been provided");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"Please configure quarkus.openfga.url or get a working docker instance");
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devConfig.imageName().orElse(OPEN_FGA_IMAGE)).asCompatibleSubstituteFor(OPEN_FGA_IMAGE);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultOpenFGAInstanceSupplier = () -> {
            QuarkusOpenFGAContainer container = (QuarkusOpenFGAContainer)new QuarkusOpenFGAContainer(dockerImageName, devConfig).withNetwork(Network.SHARED);
            timeout.ifPresent(arg_0 -> ((QuarkusOpenFGAContainer)container).withStartupTimeout(arg_0));
            log.info((Object)"Starting OpenFGA...");
            container.start();
            HashMap<String, String> devServicesConfigProperties = new HashMap<String, String>();
            DevServicesOpenFGAProcessor.withAPI(container.getHost(), container.getHttpPort(), devConfig, (instanceURL, api) -> {
                String storeId;
                devServicesConfigProperties.put(URL_CONFIG_KEY, instanceURL.toExternalForm());
                try {
                    log.info((Object)"Initializing authorization store...");
                    storeId = ((CreateStoreResponse)api.createStore(CreateStoreRequest.builder().name(devConfig.storeName()).build()).await().atMost(devConfig.startupTimeout())).id();
                    devServicesConfigProperties.put(STORE_ID_CONFIG_KEY, storeId);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Store initialization failed", e);
                }
                DevServicesOpenFGAProcessor.loadAuthorizationModelDefinition(devConfig).ifPresentOrElse(schema -> {
                    String authModelId = DevServicesOpenFGAProcessor.loadAuthorizationModel(api, storeId, schema, devConfig);
                    DevServicesOpenFGAProcessor.loadAuthorizationTuplesDefinition(devConfig).ifPresent(authTuples -> DevServicesOpenFGAProcessor.loadAuthorizationTuples(api, storeId, authModelId, authTuples, devConfig));
                }, () -> {
                    if (devConfig.authorizationTuples().isPresent() || devConfig.authorizationTuplesLocation().isPresent()) {
                        log.warn((Object)"No authorization model configured, no tuples will not be initialized");
                    }
                });
                return null;
            });
            devServicesConfigProperties.putAll(DevServicesOpenFGAProcessor.credentialsConfiguration(devConfig));
            return new DevServicesResultBuildItem.RunningDevService("openfga-client", container.getContainerId(), () -> ((QuarkusOpenFGAContainer)container).close(), devServicesConfigProperties);
        };
        return openFGAContainerLocator.locateContainer(devConfig.serviceName(), devConfig.shared(), launchMode.getLaunchMode()).map(containerAddress -> {
            HashMap<String, String> devServicesConfigProperties = new HashMap<String, String>();
            DevServicesOpenFGAProcessor.withAPI(containerAddress.getHost(), containerAddress.getPort(), devConfig, (instanceURL, api) -> {
                devServicesConfigProperties.put(URL_CONFIG_KEY, instanceURL.toExternalForm());
                String storeId = DevServicesOpenFGAProcessor.findStore(api, devConfig);
                devServicesConfigProperties.put(STORE_ID_CONFIG_KEY, storeId);
                DevServicesOpenFGAProcessor.loadAuthorizationModelDefinition(devConfig).ifPresent(store -> {
                    String authModelId = DevServicesOpenFGAProcessor.findAuthorizationModel(api, storeId, store, devConfig);
                    devServicesConfigProperties.put(AUTHORIZATION_MODEL_ID_CONFIG_KEY, authModelId);
                });
                return null;
            });
            devServicesConfigProperties.putAll(DevServicesOpenFGAProcessor.credentialsConfiguration(devConfig));
            return new DevServicesResultBuildItem.RunningDevService("openfga-client", containerAddress.getId(), null, devServicesConfigProperties);
        }).orElseGet(defaultOpenFGAInstanceSupplier);
    }

    private static Map<String, String> credentialsConfiguration(DevServicesOpenFGAConfig devConfig) {
        switch (devConfig.authentication().method()) {
            case NONE: {
                log.info((Object)"Configuring no credentials");
                return Map.of();
            }
            case PRESHARED: {
                String presharedKey = (String)devConfig.authentication().preshared().orElseThrow(() -> DevServicesOpenFGAProcessor.missingKeyError("quarkus.devservices.openfga.preshared")).keys().stream().findAny().orElseThrow(() -> DevServicesOpenFGAProcessor.configError("No pre-shared keys", AUTHN_PRESHARED_KEYS_KEY));
                log.info((Object)"Configuring preshared credentials: key=%s".formatted(presharedKey));
                return Map.of(CREDS_PRESHARED_KEY_KEY, presharedKey);
            }
            case OIDC: {
                DevServicesOpenFGAConfig.Authentication.OIDC oidc = devConfig.authentication().oidc().orElseThrow(() -> DevServicesOpenFGAProcessor.missingKeyError("quarkus.devservices.openfga.oidc"));
                log.info((Object)"Configuring oidc credentials: issuer=%s, audience=%s".formatted(oidc.issuer(), oidc.audience()));
                return Map.of(CREDS_OIDC_ISSUER_KEY, oidc.issuer(), CREDS_OIDC_AUDIENCE_KEY, oidc.audience());
            }
        }
        return Map.of();
    }

    private static Optional<AuthorizationModelSchema> loadAuthorizationModelDefinition(DevServicesOpenFGAConfig devServicesConfig) {
        return devServicesConfig.authorizationModel().or(() -> devServicesConfig.authorizationModelLocation().map(location -> {
            try {
                return DevServicesOpenFGAProcessor.readLocation(location);
            }
            catch (Throwable x) {
                throw new RuntimeException(String.format("Unable to load authorization model from '%s'", location), x);
            }
        })).map(authModelJSON -> {
            try {
                return AuthorizationModelSchema.parse((String)authModelJSON);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to parse authorization model", t);
            }
        });
    }

    private static String findStore(API api, DevServicesOpenFGAConfig config) {
        try {
            OpenFGAClient client = new OpenFGAClient(api);
            return ((List)client.listAllStores().await().atMost(config.startupTimeout())).stream().filter(store -> store.getName().equals(config.storeName())).map(Store::getId).findFirst().orElseThrow();
        }
        catch (Throwable x) {
            throw new ConfigurationException(String.format("Could not find store '%s' in shared DevServices instance", config.storeName()));
        }
    }

    private static String findAuthorizationModel(API api, String storeId, AuthorizationModelSchema schema, DevServicesOpenFGAConfig config) {
        try {
            AuthorizationModelsClient client = new AuthorizationModelsClient(api, Uni.createFrom().item((Object)storeId));
            return ((List)client.listAll().await().atMost(config.startupTimeout())).stream().filter(item -> item.getTypeDefinitions().equals(schema.getTypeDefinitions())).map(AuthorizationModel::getId).findFirst().orElseThrow();
        }
        catch (Throwable x) {
            throw new ConfigurationException("Could not find authorization model in shared DevServices instance");
        }
    }

    private static String loadAuthorizationModel(API api, String storeId, AuthorizationModelSchema schema, DevServicesOpenFGAConfig config) {
        try {
            log.info((Object)"Initializing authorization model...");
            WriteAuthorizationModelRequest request = WriteAuthorizationModelRequest.builder().schemaVersion(schema.getSchemaVersion()).typeDefinitions((Collection)schema.getTypeDefinitions()).conditions(schema.getConditions()).build();
            String authModelId = ((WriteAuthorizationModelResponse)api.writeAuthorizationModel(storeId, request).await().atMost(config.startupTimeout())).authorizationModelId();
            return authModelId;
        }
        catch (Exception e) {
            throw new RuntimeException("Model initialization failed", e);
        }
    }

    private static Optional<Collection<RelTupleKeyed>> loadAuthorizationTuplesDefinition(DevServicesOpenFGAConfig devServicesConfig) {
        return devServicesConfig.authorizationTuples().or(() -> devServicesConfig.authorizationTuplesLocation().map(location -> {
            try {
                return DevServicesOpenFGAProcessor.readLocation(location);
            }
            catch (Throwable x) {
                throw new RuntimeException(String.format("Unable to load authorization tuples from '%s'", location), x);
            }
        })).map(authTuplesJSON -> {
            try {
                return RelTupleKeys.parseList((String)authTuplesJSON).getTupleKeys();
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to parse authorization tuples", t);
            }
        });
    }

    private static void loadAuthorizationTuples(API api, String storeId, String authModelId, Collection<RelTupleKeyed> authTuples, DevServicesOpenFGAConfig config) {
        try {
            log.info((Object)"Initializing authorization tuples...");
            WriteRequest writeRequest = WriteRequest.builder().authorizationModelId(authModelId).writes(WriteRequest.Writes.of(authTuples)).build();
            api.write(storeId, writeRequest).await().atMost(config.startupTimeout());
        }
        catch (Exception e) {
            throw new RuntimeException("Tuples initialization failed", e);
        }
    }

    private static String readLocation(String location) throws IOException {
        if (location.startsWith("filesystem:")) {
            Path path = Path.of(location.substring("filesystem:".length()), new String[0]);
            return Files.readString(path);
        }
        URL resourceURL = DevServicesOpenFGAProcessor.getLocationResource(location);
        return (String)ClassPathUtils.readStream((URL)resourceURL, stream -> {
            try {
                byte[] contents = FileUtil.readFileContents((InputStream)stream);
                return new String(contents);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read resource: " + location, e);
            }
        });
    }

    private static Path resolvePath(String location) throws IOException {
        if (location.startsWith("filesystem:")) {
            return Path.of(location.substring("filesystem:".length()), new String[0]);
        }
        URL resourceURL = DevServicesOpenFGAProcessor.getLocationResource(location);
        return ClassPathUtils.toLocalPath((URL)resourceURL);
    }

    private static URL getLocationResource(String location) throws IOException {
        String resourceLocation = location.startsWith("classpath:") ? location.substring("classpath:".length()) : location;
        URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(resourceLocation);
        if (resourceURL == null) {
            resourceURL = QuarkusClassLoader.getSystemResource((String)resourceLocation);
        }
        if (resourceURL == null) {
            throw new IOException("Resource not found: " + resourceLocation);
        }
        return resourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withAPI(String host, Integer port, DevServicesOpenFGAConfig config, BiFunction<URL, API, Void> apiConsumer) {
        URL instanceURL;
        try {
            instanceURL = new URL(config.tls().isPresent() ? "https" : "http", host, port, "");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        UnauthenticatedCredentialsProvider credentialsProvider = switch (config.authentication().method()) {
            default -> throw new IncompatibleClassChangeError();
            case DevServicesOpenFGAConfig.Authentication.Method.NONE -> new UnauthenticatedCredentialsProvider();
            case DevServicesOpenFGAConfig.Authentication.Method.PRESHARED -> new PresharedKeyCredentialsProvider((String)config.authentication().preshared().orElseThrow(() -> DevServicesOpenFGAProcessor.missingKeyError("quarkus.devservices.openfga.preshared")).keys().stream().findAny().orElseThrow(() -> DevServicesOpenFGAProcessor.configError("No pre-shared keys", AUTHN_PRESHARED_KEYS_KEY)));
            case DevServicesOpenFGAConfig.Authentication.Method.OIDC -> throw new ConfigurationException("When using OIDC authentication, store, authorization model and tuples must be pre-configured");
        };
        Vertx vertx = Vertx.vertx();
        try (API api = new API(VertxWebClientFactory.create((URL)instanceURL, (Vertx)vertx), (CredentialsProvider)credentialsProvider);){
            apiConsumer.apply(instanceURL, api);
        }
        finally {
            vertx.close().await().atMost(config.startupTimeout());
        }
    }

    private static ConfigurationException missingKeyError(String key) {
        return DevServicesOpenFGAProcessor.configError("Missing configuration", key);
    }

    private static ConfigurationException configError(String message, String key) {
        return new ConfigurationException(message, Set.of(CONFIG_PREFIX + key));
    }

    static {
        first = true;
    }

    private static class QuarkusOpenFGAContainer
    extends OpenFGAContainer {
        OptionalInt fixedExposedHttpPort;
        OptionalInt fixedExposedGrpcPort;
        OptionalInt fixedExposedPlaygroundPort;
        boolean tlsEnabled;

        public QuarkusOpenFGAContainer(DockerImageName dockerImageName, DevServicesOpenFGAConfig config) {
            super(dockerImageName);
            this.fixedExposedHttpPort = config.httpPort();
            this.fixedExposedGrpcPort = config.grpcPort();
            this.fixedExposedPlaygroundPort = config.playgroundPort();
            this.withNetwork(Network.SHARED);
            this.withLabel(DevServicesOpenFGAProcessor.DEV_SERVICE_LABEL, config.serviceName());
            ArrayList<Object> command = new ArrayList<Object>();
            command.add("run");
            switch (config.authentication().method()) {
                case NONE: {
                    command.add("--authn-method=none");
                    break;
                }
                case PRESHARED: {
                    command.add("--authn-method=preshared");
                    DevServicesOpenFGAConfig.Authentication.Preshared preshared = config.authentication().preshared().orElseThrow(() -> new ConfigurationException("Missing pre-shared configuration", Set.of("quarkus.openfga.authn.preshared.keys")));
                    command.add("--authn-preshared-keys=" + String.join((CharSequence)",", preshared.keys()));
                    break;
                }
                case OIDC: {
                    command.add("--authn-method=oidc");
                    config.authentication().oidc().ifPresent(oidc -> {
                        command.add("--authn-oidc-issuer=" + oidc.issuer());
                        command.add("--authn-oidc-audience=" + oidc.audience());
                        oidc.issuerAliases().ifPresent(aliases -> command.add("--authn-oidc-issuer-aliases=" + String.join((CharSequence)",", aliases)));
                        oidc.subjects().ifPresent(subjects -> command.add("--authn-oidc-subjects=" + String.join((CharSequence)",", subjects)));
                        oidc.clientIdClaims().ifPresent(claims -> command.add("--authn-oidc-client-id-claims=" + String.join((CharSequence)",", claims)));
                    });
                }
            }
            config.tls().ifPresent(tls -> {
                try {
                    String certPath = tls.pemCertificatePath();
                    String keyPath = tls.pemKeyPath();
                    command.add("--http-tls-enabled=true");
                    command.add("--http-tls-cert=/tls/cert.pem");
                    command.add("--http-tls-key=/tls/key.pem");
                    this.withFileSystemBind(DevServicesOpenFGAProcessor.resolvePath(certPath).toAbsolutePath().toString(), "/tls/cert.pem", BindMode.READ_ONLY);
                    this.withFileSystemBind(DevServicesOpenFGAProcessor.resolvePath(keyPath).toAbsolutePath().toString(), "/tls/key.pem", BindMode.READ_ONLY);
                    this.waitingFor((WaitStrategy)Wait.forHttps((String)"/healthz").forPort(8080).forResponsePredicate(response -> response.contains("SERVING")).usingTls().allowInsecure());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to bind TLS certificate and key", e);
                }
                this.tlsEnabled = true;
            });
            this.setCommand(String.join((CharSequence)" ", command));
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedHttpPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedHttpPort.getAsInt(), 8080);
            } else {
                this.addExposedPort(8080);
            }
            if (this.fixedExposedGrpcPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedGrpcPort.getAsInt(), 8081);
            } else {
                this.addExposedPort(8081);
            }
            if (this.fixedExposedPlaygroundPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPlaygroundPort.getAsInt(), 3000);
            } else {
                this.addExposedPort(3000);
            }
        }

        public int getHttpPort() {
            if (this.fixedExposedHttpPort.isPresent()) {
                return this.fixedExposedHttpPort.getAsInt();
            }
            return super.getMappedPort(8080);
        }

        public String getHttpEndpoint() {
            return (this.tlsEnabled ? "https" : "http") + "://" + this.getHost() + ":" + this.getMappedPort(8080);
        }
    }
}

