/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.deployment;

import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public interface DevServicesOpenFGAConfig {
    public Optional<Boolean> enabled();

    public Optional<String> imageName();

    @WithDefault(value="true")
    public boolean shared();

    @WithDefault(value="openfga")
    public String serviceName();

    public OptionalInt httpPort();

    public OptionalInt grpcPort();

    public OptionalInt playgroundPort();

    @WithDefault(value="dev")
    public String storeName();

    public Optional<String> authorizationModel();

    public Optional<String> authorizationModelLocation();

    public Optional<String> authorizationTuples();

    public Optional<String> authorizationTuplesLocation();

    public Authentication authentication();

    public Optional<Tls> tls();

    @WithDefault(value="5s")
    public Duration startupTimeout();

    public static interface Authentication {
        @WithDefault(value="none")
        public Method method();

        public Optional<Preshared> preshared();

        public Optional<OIDC> oidc();

        public static interface Preshared {
            public List<String> keys();
        }

        public static interface OIDC {
            public String issuer();

            public String audience();

            public Optional<List<String>> issuerAliases();

            public Optional<List<String>> subjects();

            public Optional<List<String>> clientIdClaims();
        }

        public static enum Method {
            NONE,
            PRESHARED,
            OIDC;

        }
    }

    public static interface Tls {
        public String pemCertificatePath();

        public String pemKeyPath();
    }
}

