/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.deployment;

import io.quarkiverse.openfga.client.AuthorizationModelClient;
import io.quarkiverse.openfga.client.OpenFGAClient;
import io.quarkiverse.openfga.client.StoreClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.model.Store;
import io.quarkiverse.openfga.deployment.OpenFGABuildTimeConfig;
import io.quarkiverse.openfga.runtime.OpenFGARecorder;
import io.quarkiverse.openfga.runtime.config.OpenFGAConfig;
import io.quarkiverse.openfga.runtime.health.OpenFGAHealthCheck;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.TlsRegistryBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.function.Supplier;

class OpenFGAProcessor {
    static final String FEATURE = "openfga-client";

    OpenFGAProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerModelClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, CombinedIndexBuildItem combinedIndexBuildItem) {
        String[] modelClasses = (String[])combinedIndexBuildItem.getIndex().getKnownClasses().stream().filter(c -> c.name().packagePrefix() != null && c.name().packagePrefix().startsWith(Store.class.getPackageName())).map(c -> c.name().toString()).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.weakClass((String[])modelClasses));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem registerSyntheticBeans(OpenFGABuildTimeConfig buildTimeConfig, OpenFGAConfig runtimeConfig, VertxBuildItem vertxBuildItem, Optional<TlsRegistryBuildItem> tlsRegistryBuildItem, ShutdownContextBuildItem shutdownContextBuildItem, OpenFGARecorder recorder, Capabilities capabilities, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport) {
        Supplier<TlsConfigurationRegistry> tlsRegistrySupplier = tlsRegistryBuildItem.map(TlsRegistryBuildItem::registry).orElse(() -> null);
        RuntimeValue apiValue = recorder.createAPI(runtimeConfig, buildTimeConfig.tracing().enabled(), vertxBuildItem.getVertx(), tlsRegistrySupplier, (ShutdownContext)shutdownContextBuildItem);
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(FEATURE));
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(API.class).scope(ApplicationScoped.class)).setRuntimeInit().runtimeValue(apiValue).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(OpenFGAClient.class).scope(ApplicationScoped.class)).setRuntimeInit().runtimeValue(recorder.createClient(apiValue)).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(StoreClient.class).scope(ApplicationScoped.class)).setRuntimeInit().runtimeValue(recorder.createStoreClient(apiValue, runtimeConfig)).done());
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(AuthorizationModelClient.class).scope(ApplicationScoped.class)).setRuntimeInit().runtimeValue(recorder.createAuthModelClient(apiValue, runtimeConfig)).done());
        return new ServiceStartBuildItem(FEATURE);
    }

    @BuildStep
    void registerHealthCheck(OpenFGABuildTimeConfig buildTimeConfig, Capabilities capabilities, BuildProducer<HealthBuildItem> health) {
        if (capabilities.isPresent("io.quarkus.smallrye.health")) {
            health.produce((BuildItem)new HealthBuildItem(OpenFGAHealthCheck.class.getName(), buildTimeConfig.health().enabled()));
        }
    }
}

