/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.deployment;

import io.quarkiverse.openfga.client.AuthorizationModelsClient;
import io.quarkiverse.openfga.client.OpenFGAClient;
import io.quarkiverse.openfga.client.api.API;
import io.quarkiverse.openfga.client.api.VertxWebClientFactory;
import io.quarkiverse.openfga.client.model.AuthorizationModel;
import io.quarkiverse.openfga.client.model.Store;
import io.quarkiverse.openfga.client.model.TupleKey;
import io.quarkiverse.openfga.client.model.TupleKeys;
import io.quarkiverse.openfga.client.model.TypeDefinitions;
import io.quarkiverse.openfga.client.model.dto.CreateStoreRequest;
import io.quarkiverse.openfga.client.model.dto.CreateStoreResponse;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelResponse;
import io.quarkiverse.openfga.client.model.dto.WriteBody;
import io.quarkiverse.openfga.deployment.DevServicesOpenFGAConfig;
import io.quarkiverse.openfga.deployment.OpenFGABuildTimeConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.util.ClassPathUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.core.Vertx;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DevServicesOpenFGAProcessor {
    private static final Logger log = Logger.getLogger(DevServicesOpenFGAProcessor.class);
    static final String OPEN_FGA_VERSION = "v0.4.3";
    static final String OPEN_FGA_IMAGE = "openfga/openfga:v0.4.3";
    static final int OPEN_FGA_EXPOSED_HTTP_PORT = 8080;
    static final int OPEN_FGA_EXPOSED_GRPC_PORT = 8081;
    static final int OPEN_FGA_EXPOSED_PLAY_PORT = 3000;
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-openfga";
    static final String CONFIG_PREFIX = "quarkus.openfga.";
    static final String URL_CONFIG_KEY = "quarkus.openfga.url";
    static final String STORE_ID_CONFIG_KEY = "quarkus.openfga.store";
    static final String AUTHORIZATION_MODEL_ID_CONFIG_KEY = "quarkus.openfga.authorization-model-id";
    static final ContainerLocator openFGAContainerLocator = new ContainerLocator("quarkus-dev-service-openfga", 8080);
    static final Duration INIT_OP_MAX_WAIT = Duration.ofSeconds(5L);
    public static final String HEALTH_ENDPOINT = "/healthz";
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static volatile DevServicesOpenFGAConfig capturedDevServicesConfiguration;
    private static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startContainers(OpenFGABuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig, BuildProducer<DevServicesResultBuildItem> devServicesResults) {
        block12: {
            DevServicesOpenFGAConfig currentDevServicesConfiguration = config.devservices;
            if (devService != null) {
                boolean restartRequired;
                boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
                if (!restartRequired) {
                    return devService.toBuildItem();
                }
                try {
                    devService.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop OpenFGA container", e);
                }
                devService = null;
                capturedDevServicesConfiguration = null;
            }
            capturedDevServicesConfiguration = currentDevServicesConfiguration;
            try (StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "OpenFGA Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);){
                devService = this.startContainer(dockerStatusBuildItem, currentDevServicesConfiguration, launchMode, devServicesConfig.timeout);
                if (devService != null) {
                    if (devService.isOwner()) {
                        log.info((Object)"Dev Services for OpenFGA started.");
                        log.infof("Other Quarkus applications in dev mode will find the instance automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -D%s=%s", (Object)URL_CONFIG_KEY, devService.getConfig().get(URL_CONFIG_KEY));
                    }
                    break block12;
                }
                DevServicesResultBuildItem e = null;
                return e;
            }
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    try {
                        devService.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)"Failed to stop OpenFGA container", t);
                    }
                    devService = null;
                    log.info((Object)"Dev Services for OpenFGA shut down.");
                }
                first = true;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        return devService.toBuildItem();
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, DevServicesOpenFGAConfig devServicesConfig, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled.orElse(true).booleanValue()) {
            log.debug((Object)"Not starting devservices for OpenFGA as it has been disabled in the config");
            return null;
        }
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)URL_CONFIG_KEY);
        if (!needToStart) {
            log.debug((Object)"Not starting devservices for default OpenFGA client as url has been provided");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Please configure quarkus.openfga.url or get a working docker instance");
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName.orElse(OPEN_FGA_IMAGE)).asCompatibleSubstituteFor(OPEN_FGA_IMAGE);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultOpenFGAInstanceSupplier = () -> {
            QuarkusOpenFGAContainer container = (QuarkusOpenFGAContainer)((QuarkusOpenFGAContainer)new QuarkusOpenFGAContainer(dockerImageName, devServicesConfig.httpPort, devServicesConfig.grpcPort, devServicesConfig.playgroundPort, devServicesConfig.serviceName).withNetwork(Network.SHARED)).waitingFor((WaitStrategy)Wait.forHttp((String)HEALTH_ENDPOINT).forPort(8080));
            timeout.ifPresent(arg_0 -> ((QuarkusOpenFGAContainer)container).withStartupTimeout(arg_0));
            log.info((Object)"Starting OpenFGA...");
            container.start();
            HashMap devServicesConfigProperties = new HashMap();
            DevServicesOpenFGAProcessor.withAPI(container.getHost(), container.getHttpPort(), (instanceURL, api) -> {
                String storeId;
                devServicesConfigProperties.put(URL_CONFIG_KEY, instanceURL.toExternalForm());
                try {
                    log.info((Object)"Initializing authorization store...");
                    storeId = ((CreateStoreResponse)api.createStore(new CreateStoreRequest(devServicesConfig.storeName)).await().atMost(INIT_OP_MAX_WAIT)).getId();
                    devServicesConfigProperties.put(STORE_ID_CONFIG_KEY, storeId);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Store initialization failed", e);
                }
                DevServicesOpenFGAProcessor.loadAuthorizationModelDefinition(api, devServicesConfig).ifPresentOrElse(authModelDef -> {
                    String authModelId;
                    try {
                        log.info((Object)"Initializing authorization model...");
                        authModelId = ((WriteAuthorizationModelResponse)api.writeAuthorizationModel(storeId, authModelDef).await().atMost(INIT_OP_MAX_WAIT)).getAuthorizationModelId();
                        devServicesConfigProperties.put(AUTHORIZATION_MODEL_ID_CONFIG_KEY, authModelId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Model initialization failed", e);
                    }
                    DevServicesOpenFGAProcessor.loadAuthorizationTuples(api, devServicesConfig).ifPresent(authTuples -> {
                        try {
                            log.info((Object)"Initializing authorization tuples...");
                            api.write(storeId, new WriteBody(new TupleKeys(authTuples), null, authModelId)).await().atMost(INIT_OP_MAX_WAIT);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Tuples initialization failed", e);
                        }
                    });
                }, () -> {
                    if (devServicesConfig.authorizationTuples.isPresent() || devServicesConfig.authorizationTuplesLocation.isPresent()) {
                        log.warn((Object)"No authorization model configured, no tuples will not be initialized");
                    }
                });
                return null;
            });
            return new DevServicesResultBuildItem.RunningDevService("openfga-client", container.getContainerId(), () -> ((QuarkusOpenFGAContainer)container).close(), devServicesConfigProperties);
        };
        return openFGAContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode.getLaunchMode()).map(containerAddress -> {
            HashMap devServicesConfigProperties = new HashMap();
            DevServicesOpenFGAProcessor.withAPI(containerAddress.getHost(), containerAddress.getPort(), (instanceURL, api) -> {
                String storeId;
                devServicesConfigProperties.put(URL_CONFIG_KEY, instanceURL.toExternalForm());
                try {
                    OpenFGAClient client = new OpenFGAClient(api);
                    storeId = ((List)client.listAllStores().await().atMost(INIT_OP_MAX_WAIT)).stream().filter(store -> store.getName().equals(devServicesConfig.storeName)).map(Store::getId).findFirst().orElseThrow();
                    devServicesConfigProperties.put(STORE_ID_CONFIG_KEY, storeId);
                }
                catch (Throwable x) {
                    throw new ConfigurationException(String.format("Could not find store '%s' in shared DevServices instance", devServicesConfig.storeName));
                }
                DevServicesOpenFGAProcessor.loadAuthorizationModelDefinition(api, devServicesConfig).ifPresent(authModelDef -> {
                    try {
                        AuthorizationModelsClient client = new AuthorizationModelsClient(api, Uni.createFrom().item((Object)storeId));
                        String authModelId = ((List)client.listAll().await().atMost(INIT_OP_MAX_WAIT)).stream().filter(item -> item.getTypeDefinitions().equals(authModelDef.getTypeDefinitions())).map(AuthorizationModel::getId).findFirst().orElseThrow();
                        devServicesConfigProperties.put(AUTHORIZATION_MODEL_ID_CONFIG_KEY, authModelId);
                    }
                    catch (Throwable x) {
                        throw new ConfigurationException("Could not find authorization model in shared DevServices instance");
                    }
                });
                return null;
            });
            return new DevServicesResultBuildItem.RunningDevService("openfga-client", containerAddress.getId(), null, devServicesConfigProperties);
        }).orElseGet(defaultOpenFGAInstanceSupplier);
    }

    private static Optional<TypeDefinitions> loadAuthorizationModelDefinition(API api, DevServicesOpenFGAConfig devServicesConfig) {
        return devServicesConfig.authorizationModel.or(() -> devServicesConfig.authorizationModelLocation.map(location -> {
            try {
                Path authModelPath = DevServicesOpenFGAProcessor.resolveModelPath(location);
                return Files.readString(authModelPath);
            }
            catch (Throwable x) {
                throw new RuntimeException(String.format("Unable to load authorization model from '%s'", location));
            }
        })).map(authModelJSON -> {
            try {
                return api.parseModel(authModelJSON);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to parse authorization model", t);
            }
        });
    }

    private static Optional<List<TupleKey>> loadAuthorizationTuples(API api, DevServicesOpenFGAConfig devServicesConfig) {
        return devServicesConfig.authorizationTuples.or(() -> devServicesConfig.authorizationTuplesLocation.map(location -> {
            try {
                Path authModelPath = DevServicesOpenFGAProcessor.resolveModelPath(location);
                return Files.readString(authModelPath);
            }
            catch (Throwable x) {
                throw new RuntimeException(String.format("Unable to load authorization tuples from '%s'", location));
            }
        })).map(authTuplesJSON -> {
            try {
                return api.parseTuples(authTuplesJSON);
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to parse authorization tuples", t);
            }
        });
    }

    private static Path resolveModelPath(String location) throws IOException {
        if ((location = DevServicesOpenFGAProcessor.normalizeLocation(location)).startsWith("filesystem:")) {
            return Path.of(location.substring("filesystem:".length()), new String[0]);
        }
        AtomicReference classpathPath = new AtomicReference();
        ClassPathUtils.consumeAsPaths((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)location, classpathPath::set);
        return (Path)classpathPath.get();
    }

    private static String normalizeLocation(String location) {
        if (((String)location).startsWith("classpath:") && ((String)(location = ((String)location).substring("classpath:".length()))).startsWith("/")) {
            location = ((String)location).substring(1);
        }
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void withAPI(String host, Integer port, BiFunction<URL, API, Void> apiConsumer) {
        URL instanceURL;
        try {
            instanceURL = new URL("http", host, port, "");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Vertx vertx = Vertx.vertx();
        try (API api = new API(VertxWebClientFactory.create((URL)instanceURL, (Vertx)vertx), Optional.empty());){
            apiConsumer.apply(instanceURL, api);
        }
        finally {
            vertx.close().await().atMost(INIT_OP_MAX_WAIT);
        }
    }

    static {
        first = true;
    }

    private static class QuarkusOpenFGAContainer
    extends GenericContainer<QuarkusOpenFGAContainer> {
        OptionalInt fixedExposedHttpPort;
        OptionalInt fixedExposedGrpcPort;
        OptionalInt fixedExposedPlaygroundPort;

        public QuarkusOpenFGAContainer(DockerImageName dockerImageName, OptionalInt fixedExposedHttpPort, OptionalInt fixedExposedGrpcPort, OptionalInt fixedExposedPlaygroundPort, String serviceName) {
            super(dockerImageName);
            this.fixedExposedHttpPort = fixedExposedHttpPort;
            this.fixedExposedGrpcPort = fixedExposedGrpcPort;
            this.fixedExposedPlaygroundPort = fixedExposedPlaygroundPort;
            this.withCommand("run");
            this.withNetwork(Network.SHARED);
            if (serviceName != null) {
                this.withLabel(DevServicesOpenFGAProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedHttpPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedHttpPort.getAsInt(), 8080);
            } else {
                this.addExposedPort(8080);
            }
            if (this.fixedExposedGrpcPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedGrpcPort.getAsInt(), 8081);
            } else {
                this.addExposedPort(8081);
            }
            if (this.fixedExposedPlaygroundPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPlaygroundPort.getAsInt(), 3000);
            } else {
                this.addExposedPort(3000);
            }
        }

        public int getHttpPort() {
            if (this.fixedExposedHttpPort.isPresent()) {
                return this.fixedExposedHttpPort.getAsInt();
            }
            return super.getMappedPort(8080);
        }
    }
}

