/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.openfga.client.model.Store;
import io.quarkiverse.openfga.client.model.dto.CreateStoreRequest;
import io.quarkiverse.openfga.client.model.dto.CreateStoreResponse;
import io.quarkiverse.openfga.client.model.dto.ListStoresResponse;
import io.quarkiverse.openfga.client.model.dto.WriteAuthorizationModelResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;

public class DevServicesStoreInitializer {
    private static final ObjectMapper objectMapper = new ObjectMapper().findAndRegisterModules();
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final URI instanceURL;

    public DevServicesStoreInitializer(String instanceURL) {
        this.instanceURL = URI.create(instanceURL);
    }

    public String createStore(String name) throws Exception {
        CreateStoreRequest requestBody = new CreateStoreRequest(name);
        URI url = this.instanceURL.resolve("/stores");
        HttpRequest request = HttpRequest.newBuilder(url).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString((Object)requestBody))).header("Content-Type", "application/json").header("Accept", "application/json").build();
        HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (httpResponse.statusCode() != 201) {
            throw new IOException("Failed to create store for DevServices");
        }
        CreateStoreResponse response = (CreateStoreResponse)objectMapper.readValue(httpResponse.body(), CreateStoreResponse.class);
        return response.getId();
    }

    public Optional<String> findStoreId(String name) throws Exception {
        URI url = this.instanceURL.resolve("/stores");
        HttpRequest request = HttpRequest.newBuilder(url).GET().header("Accept", "application/json").build();
        HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (httpResponse.statusCode() != 200) {
            throw new IOException("Failed to list stores for DevServices configuration");
        }
        ListStoresResponse response = (ListStoresResponse)objectMapper.readValue(httpResponse.body(), ListStoresResponse.class);
        return response.getStores().stream().filter(store -> store.getName().equals(name)).findFirst().map(Store::getId);
    }

    public String createAuthorizationModel(String storeId, String modelJSON) throws Exception {
        URI url = this.instanceURL.resolve("/stores/" + storeId + "/authorization-models");
        HttpRequest request = HttpRequest.newBuilder(url).POST(HttpRequest.BodyPublishers.ofString(modelJSON)).header("Content-Type", "application/json").header("Accept", "application/json").build();
        HttpResponse<String> httpResponse = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (httpResponse.statusCode() != 201) {
            throw new IOException("Failed to create authorization model for devservices");
        }
        WriteAuthorizationModelResponse response = (WriteAuthorizationModelResponse)objectMapper.readValue(httpResponse.body(), WriteAuthorizationModelResponse.class);
        return response.getAuthorizationModelId();
    }
}

