/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.openfga.deployment;

import io.quarkiverse.openfga.deployment.DevServicesOpenFGAConfig;
import io.quarkiverse.openfga.deployment.DevServicesStoreInitializer;
import io.quarkiverse.openfga.deployment.OpenFGABuildTimeConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.util.ClassPathUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DevServicesOpenFGAProcessor {
    private static final Logger log = Logger.getLogger(DevServicesOpenFGAProcessor.class);
    static final String OPEN_FGA_VERSION = "v0.2.1";
    static final String OPEN_FGA_IMAGE = "openfga/openfga:v0.2.1";
    static final int OPEN_FGA_EXPOSED_PORT = 8080;
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-openfga";
    static final String CONFIG_PREFIX = "quarkus.openfga.";
    static final String URL_CONFIG_KEY = "quarkus.openfga.url";
    static final String STORE_ID_CONFIG_KEY = "quarkus.openfga.store-id";
    static final String AUTHORIZATION_MODEL_ID_CONFIG_KEY = "quarkus.openfga.authorization-model-id";
    static final ContainerLocator openFGAContainerLocator = new ContainerLocator("quarkus-dev-service-openfga", 8080);
    private static volatile DevServicesResultBuildItem.RunningDevService devService;
    private static volatile DevServicesOpenFGAConfig capturedDevServicesConfiguration;
    private static volatile boolean first;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startContainers(OpenFGABuildTimeConfig config, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, LaunchModeBuildItem launchMode, DockerStatusBuildItem dockerStatusBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig, BuildProducer<DevServicesResultBuildItem> devServicesResults) {
        block12: {
            DevServicesOpenFGAConfig currentDevServicesConfiguration = config.devservices;
            if (devService != null) {
                boolean restartRequired;
                boolean bl = restartRequired = !currentDevServicesConfiguration.equals(capturedDevServicesConfiguration);
                if (!restartRequired) {
                    return devService.toBuildItem();
                }
                try {
                    devService.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop OpenFGA container", e);
                }
                devService = null;
                capturedDevServicesConfiguration = null;
            }
            capturedDevServicesConfiguration = currentDevServicesConfiguration;
            try (StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "OpenFGA Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);){
                devService = this.startContainer(dockerStatusBuildItem, currentDevServicesConfiguration, launchMode, devServicesConfig.timeout);
                if (devService != null) {
                    if (devService.isOwner()) {
                        log.info((Object)"Dev Services for OpenFGA started.");
                        log.infof("Other Quarkus applications in dev mode will find the instance automatically. For Quarkus applications in production mode, you can connect to this by starting your application with -D%s=%s", (Object)URL_CONFIG_KEY, devService.getConfig().get(URL_CONFIG_KEY));
                    }
                    break block12;
                }
                DevServicesResultBuildItem e = null;
                return e;
            }
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    try {
                        devService.close();
                    }
                    catch (Throwable t) {
                        log.error((Object)"Failed to stop OpenFGA container", t);
                    }
                    devService = null;
                    log.info((Object)"Dev Services for OpenFGA shut down.");
                }
                first = true;
                capturedDevServicesConfiguration = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        return devService.toBuildItem();
    }

    private DevServicesResultBuildItem.RunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, DevServicesOpenFGAConfig devServicesConfig, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        boolean needToStart;
        if (!devServicesConfig.enabled.orElse(true).booleanValue()) {
            log.debug((Object)"Not starting devservices for OpenFGA as it has been disabled in the config");
            return null;
        }
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)URL_CONFIG_KEY);
        if (!needToStart) {
            log.debug((Object)"Not starting devservices for default OpenFGA client as url has been provided");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Please configure quarkus.openfga.url or get a working docker instance");
            return null;
        }
        DockerImageName dockerImageName = DockerImageName.parse((String)devServicesConfig.imageName.orElse(OPEN_FGA_IMAGE)).asCompatibleSubstituteFor(OPEN_FGA_IMAGE);
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultOpenFGAInstanceSupplier = () -> {
            String storeId;
            QuarkusOpenFGAContainer container = (QuarkusOpenFGAContainer)((QuarkusOpenFGAContainer)new QuarkusOpenFGAContainer(dockerImageName, devServicesConfig.port, devServicesConfig.serviceName).withNetwork(Network.SHARED)).waitingFor((WaitStrategy)Wait.forHttp((String)"/stores"));
            timeout.ifPresent(arg_0 -> ((QuarkusOpenFGAContainer)container).withStartupTimeout(arg_0));
            log.info((Object)"Starting OpenFGA...");
            container.start();
            String instanceURL = String.format("http://%s:%d", container.getHost(), container.getPort());
            HashMap<String, String> devServicesConfigProperties = new HashMap<String, String>();
            devServicesConfigProperties.put(URL_CONFIG_KEY, instanceURL);
            DevServicesStoreInitializer storeInitializer = new DevServicesStoreInitializer(instanceURL);
            try {
                log.info((Object)"Initializing authorization store...");
                storeId = storeInitializer.createStore(devServicesConfig.storeName);
                devServicesConfigProperties.put(STORE_ID_CONFIG_KEY, storeId);
            }
            catch (Exception e) {
                throw new RuntimeException("Store initialization failed", e);
            }
            devServicesConfig.authorizationModel.ifPresentOrElse(authModel -> {
                try {
                    log.info((Object)"Initializing authorization model...");
                    String authorizationModelId = storeInitializer.createAuthorizationModel(storeId, (String)authModel);
                    devServicesConfigProperties.put(AUTHORIZATION_MODEL_ID_CONFIG_KEY, authorizationModelId);
                }
                catch (Exception e) {
                    throw new RuntimeException("Model initialization failed", e);
                }
            }, () -> devServicesConfig.authorizationModelLocation.ifPresentOrElse(location -> {
                try {
                    log.infof("Initializing authorization model from %s...", location);
                    Path modelPath = this.resolveModelPath((String)location);
                    try (FileInputStream modelStream = new FileInputStream(modelPath.toFile());){
                        String authModel = new String(modelStream.readAllBytes(), StandardCharsets.UTF_8);
                        String authorizationModelId = storeInitializer.createAuthorizationModel(storeId, authModel);
                        devServicesConfigProperties.put(AUTHORIZATION_MODEL_ID_CONFIG_KEY, authorizationModelId);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Model initialization failed", e);
                }
            }, () -> log.info((Object)"No authentication model provided, skipping authorization store & model initialization")));
            return new DevServicesResultBuildItem.RunningDevService("openfga-client", container.getContainerId(), () -> ((QuarkusOpenFGAContainer)container).close(), devServicesConfigProperties);
        };
        return openFGAContainerLocator.locateContainer(devServicesConfig.serviceName, devServicesConfig.shared, launchMode.getLaunchMode()).map(containerAddress -> {
            String storeId;
            String instanceURL = String.format("http://%s:%d", containerAddress.getHost(), containerAddress.getPort());
            try {
                storeId = new DevServicesStoreInitializer(instanceURL).findStoreId(devServicesConfig.storeName).orElseThrow(() -> new ConfigurationException(String.format("Could not find store '%s' in shared DevServices instance", devServicesConfig.storeName)));
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to connect to shared DevServices instance", t);
            }
            Map<String, String> config = Map.of(URL_CONFIG_KEY, instanceURL, STORE_ID_CONFIG_KEY, storeId);
            return new DevServicesResultBuildItem.RunningDevService("openfga-client", containerAddress.getId(), null, config);
        }).orElseGet(defaultOpenFGAInstanceSupplier);
    }

    private Path resolveModelPath(String location) throws IOException {
        if ((location = this.normalizeLocation(location)).startsWith("filesystem:")) {
            return Path.of(location.substring("filesystem:".length()), new String[0]);
        }
        AtomicReference classpathPath = new AtomicReference();
        ClassPathUtils.consumeAsPaths((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)location, classpathPath::set);
        return (Path)classpathPath.get();
    }

    private String normalizeLocation(String location) {
        if (((String)location).startsWith("classpath:") && ((String)(location = ((String)location).substring("classpath:".length()))).startsWith("/")) {
            location = ((String)location).substring(1);
        }
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return location;
    }

    static {
        first = true;
    }

    private static class QuarkusOpenFGAContainer
    extends GenericContainer<QuarkusOpenFGAContainer> {
        OptionalInt fixedExposedPort;

        public QuarkusOpenFGAContainer(DockerImageName dockerImageName, OptionalInt fixedExposedPort, String serviceName) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.withCommand("run");
            this.withNetwork(Network.SHARED);
            if (serviceName != null) {
                this.withLabel(DevServicesOpenFGAProcessor.DEV_SERVICE_LABEL, serviceName);
            }
        }

        protected void configure() {
            super.configure();
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 8080);
            } else {
                this.addExposedPort(8080);
            }
        }

        public int getPort() {
            if (this.fixedExposedPort.isPresent()) {
                return this.fixedExposedPort.getAsInt();
            }
            return super.getMappedPort(8080);
        }
    }
}

