/*
 * Decompiled with CFR 0.152.
 */
package io.qase.cucumber3;

import cucumber.api.event.TestSourceRead;
import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.ParserException;
import gherkin.TokenMatcher;
import gherkin.ast.Examples;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Node;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableRow;
import java.util.HashMap;
import java.util.Map;

public class ScenarioStorage {
    private final Map<String, TestSourceRead> pathToScenarioMap = new HashMap<String, TestSourceRead>();
    private final Map<String, Map<Integer, CucumberNode>> pathToNodeMap = new HashMap<String, Map<Integer, CucumberNode>>();

    public static ScenarioDefinition getScenarioDefinition(CucumberNode cucumberNode) {
        return cucumberNode.node instanceof ScenarioDefinition ? (ScenarioDefinition)cucumberNode.node : (ScenarioDefinition)cucumberNode.parent.parent.node;
    }

    public void addScenarioEvent(String path, TestSourceRead event) {
        this.pathToScenarioMap.put(path, event);
    }

    public CucumberNode getCucumberNode(String path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            return this.pathToNodeMap.get(path).get(line);
        }
        return null;
    }

    private void parseGherkinSource(String path) {
        if (!this.pathToScenarioMap.containsKey(path)) {
            return;
        }
        Parser parser = new Parser((Parser.Builder)new AstBuilder());
        TokenMatcher matcher = new TokenMatcher();
        try {
            GherkinDocument gherkinDocument = (GherkinDocument)parser.parse(this.pathToScenarioMap.get((Object)path).source, (Parser.ITokenMatcher)matcher);
            HashMap<Integer, CucumberNode> nodeMap = new HashMap<Integer, CucumberNode>();
            CucumberNode currentParent = new CucumberNode((Node)gherkinDocument.getFeature(), null);
            for (ScenarioDefinition child : gherkinDocument.getFeature().getChildren()) {
                this.processScenarioDefinition(nodeMap, child, currentParent);
            }
            this.pathToNodeMap.put(path, nodeMap);
        }
        catch (ParserException e) {
            throw new IllegalStateException("You are using a plugin that only supports till Gherkin 5.\nPlease check if the Gherkin provided follows the standard of Gherkin 5\n", e);
        }
    }

    private void processScenarioDefinition(Map<Integer, CucumberNode> nodeMap, ScenarioDefinition child, CucumberNode currentParent) {
        CucumberNode childNode = new CucumberNode((Node)child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Step step : child.getSteps()) {
            nodeMap.put(step.getLocation().getLine(), ScenarioStorage.createCucumberNode((Node)step, childNode));
        }
        if (child instanceof ScenarioOutline) {
            this.processScenarioOutlineExamples(nodeMap, (ScenarioOutline)child, childNode);
        }
    }

    private void processScenarioOutlineExamples(Map<Integer, CucumberNode> nodeMap, ScenarioOutline scenarioOutline, CucumberNode childNode) {
        for (Examples examples : scenarioOutline.getExamples()) {
            CucumberNode examplesNode = ScenarioStorage.createCucumberNode((Node)examples, childNode);
            TableRow headerRow = examples.getTableHeader();
            CucumberNode headerNode = ScenarioStorage.createCucumberNode((Node)headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            for (int i = 0; i < examples.getTableBody().size(); ++i) {
                TableRow examplesRow = (TableRow)examples.getTableBody().get(i);
                ExamplesRowWrapperNode rowNode = ScenarioStorage.createExamplesRowWrapperNode((Node)examplesRow, i);
                CucumberNode expandedScenarioNode = ScenarioStorage.createCucumberNode(rowNode, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
            }
        }
    }

    private static ExamplesRowWrapperNode createExamplesRowWrapperNode(Node examplesRow, int bodyRowIndex) {
        return new ExamplesRowWrapperNode(examplesRow, bodyRowIndex);
    }

    private static CucumberNode createCucumberNode(Node node, CucumberNode astNode) {
        return new CucumberNode(node, astNode);
    }

    public static class CucumberNode {
        private final Node node;
        private final CucumberNode parent;

        CucumberNode(Node node, CucumberNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }

    public static class ExamplesRowWrapperNode
    extends Node {
        private final int bodyRowIndex;

        public int getBodyRowIndex() {
            return this.bodyRowIndex;
        }

        ExamplesRowWrapperNode(Node examplesRow, int bodyRowIndex) {
            super(examplesRow.getLocation());
            this.bodyRowIndex = bodyRowIndex;
        }
    }
}

