/*
 * Decompiled with CFR 0.152.
 */
package io.qase.cucumber3;

import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.formatter.Formatter;
import gherkin.pickles.PickleTag;
import io.qase.commons.CasesStorage;
import io.qase.commons.StepStorage;
import io.qase.commons.models.domain.Relations;
import io.qase.commons.models.domain.StepResult;
import io.qase.commons.models.domain.StepResultStatus;
import io.qase.commons.models.domain.SuiteData;
import io.qase.commons.models.domain.TestResult;
import io.qase.commons.models.domain.TestResultStatus;
import io.qase.commons.reporters.CoreReporterFactory;
import io.qase.commons.reporters.Reporter;
import io.qase.commons.utils.CucumberUtils;
import io.qase.commons.utils.IntegrationUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import okio.Path;

public class QaseEventListener
implements Formatter {
    private final Reporter qaseTestCaseListener = CoreReporterFactory.getInstance();

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this::testCaseStarted);
        publisher.registerHandlerFor(TestCaseFinished.class, this::testCaseFinished);
        publisher.registerHandlerFor(TestRunStarted.class, this::testRunStarted);
        publisher.registerHandlerFor(TestRunFinished.class, this::testRunFinished);
        publisher.registerHandlerFor(TestStepStarted.class, this::testStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::testStepFinished);
    }

    private void testRunStarted(TestRunStarted testRunStarted) {
        this.qaseTestCaseListener.startTestRun();
    }

    private void testRunFinished(TestRunFinished testRunFinished) {
        this.qaseTestCaseListener.uploadResults();
        this.qaseTestCaseListener.completeTestRun();
    }

    private void testStepStarted(TestStepStarted testStepStarted) {
        if (testStepStarted.testStep instanceof PickleStepTestStep) {
            StepStorage.startStep();
        }
    }

    private void testStepFinished(TestStepFinished testStepFinished) {
        if (testStepFinished.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep step = (PickleStepTestStep)testStepFinished.testStep;
            StepResult stepResult = StepStorage.getCurrentStep();
            stepResult.data.action = step.getStepText();
            stepResult.execution.status = this.convertStepStatus(testStepFinished.result.getStatus());
            StepStorage.stopStep();
        }
    }

    private void testCaseStarted(TestCaseStarted event) {
        TestResult resultCreate = this.startTestCase(event);
        CasesStorage.startCase((TestResult)resultCreate);
    }

    private void testCaseFinished(TestCaseFinished event) {
        TestResult result = this.stopTestCase(event);
        if (result == null) {
            return;
        }
        this.qaseTestCaseListener.addResult(result);
    }

    private TestResult startTestCase(TestCaseStarted event) {
        TestResult resultCreate = new TestResult();
        List tags = event.testCase.getTags().stream().map(PickleTag::getName).collect(Collectors.toList());
        boolean ignore = CucumberUtils.getCaseIgnore(tags);
        if (ignore) {
            resultCreate.ignore = true;
            return resultCreate;
        }
        Long caseId = CucumberUtils.getCaseId(tags);
        Map fields = CucumberUtils.getCaseFields(tags);
        String caseTitle = Optional.ofNullable(CucumberUtils.getCaseTitle(tags)).orElse(event.testCase.getName());
        String suite = CucumberUtils.getCaseSuite(tags);
        Relations relations = new Relations();
        if (suite != null) {
            String[] parts;
            for (String part : parts = suite.split("\t")) {
                SuiteData data = new SuiteData();
                data.title = part;
                relations.suite.data.add(data);
            }
        } else {
            SuiteData className = new SuiteData();
            String[] parts = event.testCase.getScenarioDesignation().split(":")[0].split(Path.DIRECTORY_SEPARATOR);
            className.title = parts[parts.length - 1];
            relations.suite.data.add(className);
        }
        resultCreate.title = caseTitle;
        resultCreate.testopsId = caseId;
        resultCreate.execution.startTime = System.currentTimeMillis();
        resultCreate.fields = fields;
        resultCreate.relations = relations;
        return resultCreate;
    }

    private TestResult stopTestCase(TestCaseFinished event) {
        TestResult resultCreate = CasesStorage.getCurrentCase();
        CasesStorage.stopCase();
        if (resultCreate.ignore) {
            return null;
        }
        Optional<Throwable> optionalThrowable = Optional.ofNullable(event.result.getError());
        String stacktrace = optionalThrowable.flatMap(throwable -> Optional.of(IntegrationUtils.getStacktrace((Throwable)throwable))).orElse(null);
        resultCreate.execution.status = this.convertStatus(event.result.getStatus());
        resultCreate.execution.endTime = System.currentTimeMillis();
        resultCreate.execution.duration = (int)(resultCreate.execution.endTime - resultCreate.execution.startTime);
        resultCreate.execution.stacktrace = stacktrace;
        resultCreate.steps = StepStorage.stopSteps();
        optionalThrowable.ifPresent(throwable -> {
            resultCreate.message = Optional.ofNullable(resultCreate.message).map(msg -> msg + "\n\n" + throwable.toString()).orElse(throwable.toString());
        });
        return resultCreate;
    }

    private TestResultStatus convertStatus(Result.Type status) {
        switch (status) {
            case FAILED: {
                return TestResultStatus.FAILED;
            }
            case PASSED: {
                return TestResultStatus.PASSED;
            }
        }
        return TestResultStatus.SKIPPED;
    }

    private StepResultStatus convertStepStatus(Result.Type status) {
        switch (status) {
            case PASSED: {
                return StepResultStatus.PASSED;
            }
            case FAILED: {
                return StepResultStatus.FAILED;
            }
        }
        return StepResultStatus.BLOCKED;
    }
}

