/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.processors;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/qalipsis/api/processors/TypeUtils;", "", "elementUtils", "Ljavax/lang/model/util/Elements;", "typeUtils", "Ljavax/lang/model/util/Types;", "(Ljavax/lang/model/util/Elements;Ljavax/lang/model/util/Types;)V", "iterableType", "Ljavax/lang/model/type/TypeMirror;", "kotlin.jvm.PlatformType", "optionalType", "erase", "type", "getTypeElement", "Ljavax/lang/model/element/TypeElement;", "typeMirror", "getTypeOfFirstGeneric", "Ljavax/lang/model/type/DeclaredType;", "isAKotlinObject", "", "typeElement", "isIterableWithGeneric", "isOptionalWithGeneric", "qalipsis-api-processors"})
@SourceDebugExtension(value={"SMAP\nTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeUtils.kt\nio/qalipsis/api/processors/TypeUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1747#2,3:85\n*S KotlinDebug\n*F\n+ 1 TypeUtils.kt\nio/qalipsis/api/processors/TypeUtils\n*L\n47#1:85,3\n*E\n"})
public final class TypeUtils {
    @NotNull
    private final Elements elementUtils;
    @NotNull
    private final Types typeUtils;
    private final TypeMirror iterableType;
    private final TypeMirror optionalType;

    public TypeUtils(@NotNull Elements elementUtils, @NotNull Types typeUtils) {
        Intrinsics.checkNotNullParameter((Object)elementUtils, (String)"elementUtils");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.iterableType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Iterable.class.getName()).asType());
        this.optionalType = this.typeUtils.erasure(this.elementUtils.getTypeElement(Optional.class.getName()).asType());
    }

    public final boolean isAKotlinObject(@NotNull TypeElement typeElement) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)typeElement, (String)"typeElement");
            List<? extends Element> list = this.elementUtils.getAllMembers(typeElement);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllMembers(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Element it = (Element)element$iv;
                    boolean bl2 = false;
                    if (!(it.getKind() == ElementKind.FIELD && Intrinsics.areEqual((Object)it.getSimpleName().toString(), (Object)"INSTANCE"))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isIterableWithGeneric(@NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof DeclaredType && ((DeclaredType)type).getTypeArguments().size() == 1) {
            return this.typeUtils.isSubtype(this.typeUtils.erasure(type), this.iterableType);
        }
        return false;
    }

    public final boolean isOptionalWithGeneric(@NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof DeclaredType && ((DeclaredType)type).getTypeArguments().size() == 1) {
            return this.typeUtils.isSubtype(this.typeUtils.erasure(type), this.optionalType);
        }
        return false;
    }

    @NotNull
    public final TypeMirror getTypeOfFirstGeneric(@NotNull DeclaredType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List<? extends TypeMirror> list = type.getTypeArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeArguments(...)");
        TypeMirror genericType = (TypeMirror)CollectionsKt.first(list);
        if (genericType instanceof WildcardType) {
            genericType = this.typeUtils.erasure(genericType);
        }
        TypeMirror typeMirror = genericType;
        Intrinsics.checkNotNull((Object)typeMirror);
        return typeMirror;
    }

    @NotNull
    public final TypeMirror erase(@NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        TypeMirror typeMirror = this.typeUtils.erasure(type);
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"erasure(...)");
        return typeMirror;
    }

    @Nullable
    public final TypeElement getTypeElement(@NotNull TypeMirror typeMirror) {
        Intrinsics.checkNotNullParameter((Object)typeMirror, (String)"typeMirror");
        return (TypeElement)this.typeUtils.asElement(typeMirror);
    }
}

