/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.processors;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.qalipsis.api.annotations.Scenario;
import io.qalipsis.api.processors.ExecutableScenarioMethod;
import io.qalipsis.api.processors.InjectionResolutionUtils;
import io.qalipsis.api.processors.ScenarioAnnotationProcessor;
import io.qalipsis.api.processors.ScenarioLoaderClassGenerator;
import io.qalipsis.api.processors.TypeUtils;
import io.qalipsis.api.services.ServicesFiles;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@SupportedAnnotationTypes(value={"io.qalipsis.api.annotations.Scenario"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/qalipsis/api/processors/ScenarioAnnotationProcessor;", "Ljavax/annotation/processing/AbstractProcessor;", "()V", "injectionResolutionUtils", "Lio/qalipsis/api/processors/InjectionResolutionUtils;", "typeUtils", "Lio/qalipsis/api/processors/TypeUtils;", "init", "", "processingEnv", "Ljavax/annotation/processing/ProcessingEnvironment;", "process", "", "annotations", "", "Ljavax/lang/model/element/TypeElement;", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "Companion", "ScenarioResourceMetadata", "qalipsis-api-processors"})
@SourceDebugExtension(value={"SMAP\nScenarioAnnotationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScenarioAnnotationProcessor.kt\nio/qalipsis/api/processors/ScenarioAnnotationProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,162:1\n1549#2:163\n1620#2,3:164\n1194#2,2:167\n1222#2,4:169\n1313#3,2:173\n125#4:175\n152#4,3:176\n*S KotlinDebug\n*F\n+ 1 ScenarioAnnotationProcessor.kt\nio/qalipsis/api/processors/ScenarioAnnotationProcessor\n*L\n86#1:163\n86#1:164,3\n88#1:167,2\n88#1:169,4\n97#1:173,2\n129#1:175\n129#1:176,3\n*E\n"})
public final class ScenarioAnnotationProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private TypeUtils typeUtils;
    private InjectionResolutionUtils injectionResolutionUtils;
    @NotNull
    public static final String SCENARIOS_PATH = "META-INF/services/qalipsis/scenarios";
    @NotNull
    public static final String ANNOTATION_CLASS_NAME = "io.qalipsis.api.annotations.Scenario";
    @NotNull
    public static final String RESOURCE_FIELD_SEPARATOR = "\t";

    @Override
    public void init(@NotNull ProcessingEnvironment processingEnv) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        super.init(processingEnv);
        Elements elements = processingEnv.getElementUtils();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getElementUtils(...)");
        Types types = processingEnv.getTypeUtils();
        Intrinsics.checkNotNullExpressionValue((Object)types, (String)"getTypeUtils(...)");
        this.typeUtils = new TypeUtils(elements, types);
        TypeUtils typeUtils = this.typeUtils;
        if (typeUtils == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
            typeUtils = null;
        }
        this.injectionResolutionUtils = new InjectionResolutionUtils(typeUtils);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean process(@Nullable Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        void $this$forEach$iv;
        Iterator $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        Object object2;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(Scenario.class);
        if (annotatedElements.isEmpty()) {
            return false;
        }
        Filer filer = this.processingEnv.getFiler();
        FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", SCENARIOS_PATH);
        try {
            InputStream inputStream = existingFile.openInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openInputStream(...)");
            iterable = ServicesFiles.INSTANCE.readFile(inputStream);
        }
        catch (IOException e) {
            iterable = SetsKt.emptySet();
        }
        iterable = iterable;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void line;
            object2 = (String)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ScenarioResourceMetadata.Companion.ofLine((String)line));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        item$iv$iv2 = $this$associateByTo$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            void it;
            Object element$iv$iv = item$iv$iv2.next();
            ScenarioResourceMetadata bl = (ScenarioResourceMetadata)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getScenarioName(), element$iv$iv);
        }
        Map alreadyProcessedScenarios = destination$iv$iv2;
        Map allScenariosByName = MapsKt.toMutableMap((Map)alreadyProcessedScenarios);
        Intrinsics.checkNotNull(annotatedElements);
        Sequence $i$f$associateBy22 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)annotatedElements), (Function1)process.1.INSTANCE), (Function1)process.2.INSTANCE);
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            InjectionResolutionUtils injectionResolutionUtils;
            ExecutableScenarioMethod executableMethod = (ExecutableScenarioMethod)element$iv2;
            boolean bl = false;
            Messager messager = this.processingEnv.getMessager();
            Intrinsics.checkNotNullExpressionValue((Object)messager, (String)"getMessager(...)");
            TypeUtils typeUtils = this.typeUtils;
            if (typeUtils == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeUtils");
                typeUtils = null;
            }
            if ((injectionResolutionUtils = this.injectionResolutionUtils) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"injectionResolutionUtils");
                injectionResolutionUtils = null;
            }
            ScenarioLoaderClassGenerator scenarioLoaderClassGenerator = new ScenarioLoaderClassGenerator(executableMethod, messager, typeUtils, injectionResolutionUtils);
            TypeSpec loaderSpec = scenarioLoaderClassGenerator.generateClassLoader();
            if (allScenariosByName.containsKey(scenarioLoaderClassGenerator.getScenarioName())) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The scenario with name " + scenarioLoaderClassGenerator.getScenarioName() + " already exists in the source files");
            }
            allScenariosByName.put(scenarioLoaderClassGenerator.getScenarioName(), new ScenarioResourceMetadata(scenarioLoaderClassGenerator.getScenarioName(), scenarioLoaderClassGenerator.getScenarioDescription(), scenarioLoaderClassGenerator.getScenarioVersion(), executableMethod.getLoaderFullClassName()));
            JavaFile javaFile = JavaFile.builder((String)"io.qalipsis.api.scenariosloader", (TypeSpec)loaderSpec).build();
            JavaFileObject loader = filer.createSourceFile(String.valueOf(executableMethod.getLoaderFullClassName()), new Element[0]);
            Closeable closeable = new OutputStreamWriter(loader.openOutputStream(), StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)closeable;
                boolean bl3 = false;
                javaFile.writeTo((Appendable)writer);
                writer.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        FileObject scenariosFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", SCENARIOS_PATH, new Element[0]);
        Map $i$f$forEach22 = allScenariosByName;
        object = ServicesFiles.INSTANCE;
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        object2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            void it;
            Map.Entry item$iv$iv3;
            Map.Entry javaFile = item$iv$iv3 = (Map.Entry)object2.next();
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(((ScenarioResourceMetadata)it.getValue()).getAsResource());
        }
        Collection collection = (List)destination$iv$iv3;
        OutputStream outputStream = scenariosFile.openOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"openOutputStream(...)");
        object.writeFile(collection, outputStream);
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/qalipsis/api/processors/ScenarioAnnotationProcessor$Companion;", "", "()V", "ANNOTATION_CLASS_NAME", "", "RESOURCE_FIELD_SEPARATOR", "SCENARIOS_PATH", "qalipsis-api-processors"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/qalipsis/api/processors/ScenarioAnnotationProcessor$ScenarioResourceMetadata;", "", "scenarioName", "", "scenarioDescription", "scenarioVersion", "scenarioLoader", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "asResource", "getAsResource", "()Ljava/lang/String;", "getScenarioDescription", "getScenarioLoader", "getScenarioName", "getScenarioVersion", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "qalipsis-api-processors"})
    private static final class ScenarioResourceMetadata {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String scenarioName;
        @NotNull
        private final String scenarioDescription;
        @NotNull
        private final String scenarioVersion;
        @NotNull
        private final String scenarioLoader;
        @NotNull
        private final String asResource;

        public ScenarioResourceMetadata(@NotNull String scenarioName, @NotNull String scenarioDescription, @NotNull String scenarioVersion, @NotNull String scenarioLoader) {
            Intrinsics.checkNotNullParameter((Object)scenarioName, (String)"scenarioName");
            Intrinsics.checkNotNullParameter((Object)scenarioDescription, (String)"scenarioDescription");
            Intrinsics.checkNotNullParameter((Object)scenarioVersion, (String)"scenarioVersion");
            Intrinsics.checkNotNullParameter((Object)scenarioLoader, (String)"scenarioLoader");
            this.scenarioName = scenarioName;
            this.scenarioDescription = scenarioDescription;
            this.scenarioVersion = scenarioVersion;
            this.scenarioLoader = scenarioLoader;
            this.asResource = this.scenarioName + ScenarioAnnotationProcessor.RESOURCE_FIELD_SEPARATOR + this.scenarioDescription + ScenarioAnnotationProcessor.RESOURCE_FIELD_SEPARATOR + this.scenarioVersion + ScenarioAnnotationProcessor.RESOURCE_FIELD_SEPARATOR + this.scenarioLoader;
        }

        @NotNull
        public final String getScenarioName() {
            return this.scenarioName;
        }

        @NotNull
        public final String getScenarioDescription() {
            return this.scenarioDescription;
        }

        @NotNull
        public final String getScenarioVersion() {
            return this.scenarioVersion;
        }

        @NotNull
        public final String getScenarioLoader() {
            return this.scenarioLoader;
        }

        @NotNull
        public final String getAsResource() {
            return this.asResource;
        }

        @NotNull
        public final String component1() {
            return this.scenarioName;
        }

        @NotNull
        public final String component2() {
            return this.scenarioDescription;
        }

        @NotNull
        public final String component3() {
            return this.scenarioVersion;
        }

        @NotNull
        public final String component4() {
            return this.scenarioLoader;
        }

        @NotNull
        public final ScenarioResourceMetadata copy(@NotNull String scenarioName, @NotNull String scenarioDescription, @NotNull String scenarioVersion, @NotNull String scenarioLoader) {
            Intrinsics.checkNotNullParameter((Object)scenarioName, (String)"scenarioName");
            Intrinsics.checkNotNullParameter((Object)scenarioDescription, (String)"scenarioDescription");
            Intrinsics.checkNotNullParameter((Object)scenarioVersion, (String)"scenarioVersion");
            Intrinsics.checkNotNullParameter((Object)scenarioLoader, (String)"scenarioLoader");
            return new ScenarioResourceMetadata(scenarioName, scenarioDescription, scenarioVersion, scenarioLoader);
        }

        public static /* synthetic */ ScenarioResourceMetadata copy$default(ScenarioResourceMetadata scenarioResourceMetadata, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = scenarioResourceMetadata.scenarioName;
            }
            if ((n & 2) != 0) {
                string2 = scenarioResourceMetadata.scenarioDescription;
            }
            if ((n & 4) != 0) {
                string3 = scenarioResourceMetadata.scenarioVersion;
            }
            if ((n & 8) != 0) {
                string4 = scenarioResourceMetadata.scenarioLoader;
            }
            return scenarioResourceMetadata.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ScenarioResourceMetadata(scenarioName=" + this.scenarioName + ", scenarioDescription=" + this.scenarioDescription + ", scenarioVersion=" + this.scenarioVersion + ", scenarioLoader=" + this.scenarioLoader + ")";
        }

        public int hashCode() {
            int result = this.scenarioName.hashCode();
            result = result * 31 + this.scenarioDescription.hashCode();
            result = result * 31 + this.scenarioVersion.hashCode();
            result = result * 31 + this.scenarioLoader.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScenarioResourceMetadata)) {
                return false;
            }
            ScenarioResourceMetadata scenarioResourceMetadata = (ScenarioResourceMetadata)other;
            if (!Intrinsics.areEqual((Object)this.scenarioName, (Object)scenarioResourceMetadata.scenarioName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scenarioDescription, (Object)scenarioResourceMetadata.scenarioDescription)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.scenarioVersion, (Object)scenarioResourceMetadata.scenarioVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.scenarioLoader, (Object)scenarioResourceMetadata.scenarioLoader);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/qalipsis/api/processors/ScenarioAnnotationProcessor$ScenarioResourceMetadata$Companion;", "", "()V", "ofLine", "Lio/qalipsis/api/processors/ScenarioAnnotationProcessor$ScenarioResourceMetadata;", "line", "", "qalipsis-api-processors"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ScenarioResourceMetadata ofLine(@NotNull String line) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                String[] stringArray = new String[]{ScenarioAnnotationProcessor.RESOURCE_FIELD_SEPARATOR};
                List tokens = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                return new ScenarioResourceMetadata((String)tokens.get(0), (String)tokens.get(1), (String)tokens.get(2), (String)tokens.get(3));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

