/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.processors;

import io.qalipsis.api.annotations.Property;
import io.qalipsis.api.processors.TypeUtils;
import jakarta.inject.Named;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/qalipsis/api/processors/InjectionResolutionUtils;", "", "typeUtils", "Lio/qalipsis/api/processors/TypeUtils;", "(Lio/qalipsis/api/processors/TypeUtils;)V", "buildNamedQualifierResolution", "", "named", "Ljakarta/inject/Named;", "paramType", "Ljavax/lang/model/type/TypeMirror;", "buildPropertyResolution", "property", "Lio/qalipsis/api/annotations/Property;", "buildUnqualifiedResolution", "Companion", "qalipsis-api-processors"})
public final class InjectionResolutionUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TypeUtils typeUtils;
    @NotNull
    private static final Map<String, String> PRIMITIVES_TYPES;

    public InjectionResolutionUtils(@NotNull TypeUtils typeUtils) {
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        this.typeUtils = typeUtils;
    }

    @NotNull
    public final String buildPropertyResolution(@NotNull Property property, @NotNull TypeMirror paramType) {
        Object propertyTypeName;
        Object object;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)paramType, (String)"paramType");
        boolean isOptional = false;
        if (this.typeUtils.isOptionalWithGeneric(paramType)) {
            isOptional = true;
            object = this.typeUtils.getTypeOfFirstGeneric((DeclaredType)paramType) + ".class";
        } else {
            object = propertyTypeName = paramType instanceof PrimitiveType ? PRIMITIVES_TYPES.get(((Object)paramType).toString()) : this.typeUtils.erase(paramType) + ".class";
        }
        return StringsKt.isBlank((CharSequence)property.orElse()) || isOptional ? (isOptional ? "(" + paramType + ") injector.getProperty(\"" + property.name() + "\", " + (String)propertyTypeName + ")" : "injector.getRequiredProperty(\"" + property.name() + "\", " + (String)propertyTypeName + ")") : "injector.getProperty(\"" + property.name() + "\", " + (String)propertyTypeName + ", (" + paramType + ") injector.getConversionService().convertRequired(\"" + property.orElse() + "\", " + (String)propertyTypeName + "))";
    }

    @NotNull
    public final String buildUnqualifiedResolution(@NotNull TypeMirror paramType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)paramType, (String)"paramType");
        if (this.typeUtils.isOptionalWithGeneric(paramType)) {
            TypeMirror genericType = this.typeUtils.getTypeOfFirstGeneric((DeclaredType)paramType);
            object = "injector.findBean(" + genericType + ".class)";
        } else if (this.typeUtils.isIterableWithGeneric(paramType)) {
            TypeMirror genericType = this.typeUtils.getTypeOfFirstGeneric((DeclaredType)paramType);
            object = StringsKt.trimIndent((String)("(" + paramType + ") injector.getConversionService().convertRequired(injector.getBeansOfType(" + genericType + ".class), \n                    " + this.typeUtils.erase(paramType) + ".class)"));
        } else {
            object = "injector.getBean(" + paramType + ".class)";
        }
        return object;
    }

    @NotNull
    public final String buildNamedQualifierResolution(@NotNull Named named, @NotNull TypeMirror paramType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)named, (String)"named");
        Intrinsics.checkNotNullParameter((Object)paramType, (String)"paramType");
        if (this.typeUtils.isOptionalWithGeneric(paramType)) {
            TypeMirror genericType = this.typeUtils.getTypeOfFirstGeneric((DeclaredType)paramType);
            string = "injector.findBean(" + genericType + ".class, io.micronaut.inject.qualifiers.Qualifiers.byName(\"" + named.value() + "\"))";
        } else if (this.typeUtils.isIterableWithGeneric(paramType)) {
            TypeMirror genericType = this.typeUtils.getTypeOfFirstGeneric((DeclaredType)paramType);
            string = "(" + paramType + ") injector.getConversionService().convertRequired(injector.getBeansOfType(" + genericType + ".class, io.micronaut.inject.qualifiers.Qualifiers.byName(\"" + named.value() + "\")), " + this.typeUtils.erase(paramType) + ".class)";
        } else {
            string = "injector.getBean(" + paramType + ".class, io.micronaut.inject.qualifiers.Qualifiers.byName(\"" + named.value() + "\"))";
        }
        return string;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"boolean", (Object)"java.lang.Boolean.TYPE"), TuplesKt.to((Object)"byte", (Object)"java.lang.Byte.TYPE"), TuplesKt.to((Object)"short", (Object)"java.lang.Short.TYPE"), TuplesKt.to((Object)"int", (Object)"java.lang.Integer.TYPE"), TuplesKt.to((Object)"long", (Object)"java.lang.Long.TYPE"), TuplesKt.to((Object)"char", (Object)"java.lang.Character.TYPE"), TuplesKt.to((Object)"float", (Object)"java.lang.Float.TYPE"), TuplesKt.to((Object)"double", (Object)"java.lang.Double.TYPE")};
        PRIMITIVES_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lio/qalipsis/api/processors/InjectionResolutionUtils$Companion;", "", "()V", "PRIMITIVES_TYPES", "", "", "getPRIMITIVES_TYPES$annotations", "qalipsis-api-processors"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getPRIMITIVES_TYPES$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

