/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.steps;

import io.qalipsis.api.constraints.PositiveOrZeroDuration;
import io.qalipsis.api.retry.RetryPolicy;
import io.qalipsis.api.scenario.StepSpecificationRegistry;
import io.qalipsis.api.steps.ConfigurableStepSpecification;
import io.qalipsis.api.steps.StepReportingSpecification;
import io.qalipsis.api.steps.StepSpecification;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import kotlin.ExtensionFunctionType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u001a\b\u0002\u0010\u0003*\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010D\u001a\u00020E2\u0012\u0010F\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H\u0016J \u0010G\u001a\u00020E2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010H\u001a\u00020\u000f2\u0006\u0010I\u001a\u000205H\u0016J!\u0010J\u001a\u00020E2\u0017\u0010K\u001a\u0013\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020E0L\u00a2\u0006\u0002\bMH\u0016J\u0010\u0010N\u001a\u00020E2\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u0010O\u001a\u00020E2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0;H\u0016J\u0010\u0010A\u001a\u00020E2\u0006\u0010P\u001a\u00020\u000fH\u0016R\"\u0010\u0007\u001a\u00060\bj\u0002`\t8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00158\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00060\bj\u0002`\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000b\"\u0004\b\u001d\u0010\rR&\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00040\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001e\u0010.\u001a\u00020/8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u000205X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R&\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0;X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u000e\u0010@\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010A\u001a\u0004\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0011\"\u0004\bC\u0010\u0013\u00a8\u0006Q"}, d2={"Lio/qalipsis/api/steps/AbstractStepSpecification;", "INPUT", "OUTPUT", "SELF", "Lio/qalipsis/api/steps/StepSpecification;", "Lio/qalipsis/api/steps/ConfigurableStepSpecification;", "()V", "directedAcyclicGraphName", "", "Lio/qalipsis/api/context/DirectedAcyclicGraphName;", "getDirectedAcyclicGraphName", "()Ljava/lang/String;", "setDirectedAcyclicGraphName", "(Ljava/lang/String;)V", "iterationPeriods", "Ljava/time/Duration;", "getIterationPeriods", "()Ljava/time/Duration;", "setIterationPeriods", "(Ljava/time/Duration;)V", "iterations", "", "getIterations", "()J", "setIterations", "(J)V", "name", "Lio/qalipsis/api/context/StepName;", "getName", "setName", "nextSteps", "", "getNextSteps", "()Ljava/util/List;", "reporting", "Lio/qalipsis/api/steps/StepReportingSpecification;", "getReporting", "()Lio/qalipsis/api/steps/StepReportingSpecification;", "setReporting", "(Lio/qalipsis/api/steps/StepReportingSpecification;)V", "retryPolicy", "Lio/qalipsis/api/retry/RetryPolicy;", "getRetryPolicy", "()Lio/qalipsis/api/retry/RetryPolicy;", "setRetryPolicy", "(Lio/qalipsis/api/retry/RetryPolicy;)V", "scenario", "Lio/qalipsis/api/scenario/StepSpecificationRegistry;", "getScenario", "()Lio/qalipsis/api/scenario/StepSpecificationRegistry;", "setScenario", "(Lio/qalipsis/api/scenario/StepSpecificationRegistry;)V", "stopIterationsOnError", "", "getStopIterationsOnError", "()Z", "setStopIterationsOnError", "(Z)V", "tags", "", "getTags", "()Ljava/util/Map;", "setTags", "(Ljava/util/Map;)V", "tagsSet", "timeout", "getTimeout", "setTimeout", "add", "", "step", "iterate", "period", "stopOnError", "report", "specification", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "retry", "tag", "duration", "qalipsis-api-dsl"})
public abstract class AbstractStepSpecification<INPUT, OUTPUT, SELF extends StepSpecification<INPUT, OUTPUT, SELF>>
implements ConfigurableStepSpecification<INPUT, OUTPUT, SELF> {
    @org.jetbrains.annotations.NotNull
    private String name = "";
    @NotNull
    public StepSpecificationRegistry scenario;
    @NotBlank
    @org.jetbrains.annotations.NotNull
    private String directedAcyclicGraphName = "";
    @Nullable
    private Duration timeout;
    @Positive
    private long iterations = 1L;
    @PositiveOrZeroDuration
    @org.jetbrains.annotations.NotNull
    private Duration iterationPeriods;
    private boolean stopIterationsOnError;
    @Nullable
    private RetryPolicy retryPolicy;
    @org.jetbrains.annotations.NotNull
    private final List<StepSpecification<?, ?, ?>> nextSteps;
    @org.jetbrains.annotations.NotNull
    private StepReportingSpecification reporting;
    private boolean tagsSet;
    @org.jetbrains.annotations.NotNull
    private Map<String, String> tags;

    public AbstractStepSpecification() {
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        this.iterationPeriods = duration;
        this.nextSteps = new ArrayList();
        this.reporting = new StepReportingSpecification(false, 1, null);
        this.tags = MapsKt.emptyMap();
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@org.jetbrains.annotations.NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public StepSpecificationRegistry getScenario() {
        StepSpecificationRegistry stepSpecificationRegistry = this.scenario;
        if (stepSpecificationRegistry != null) {
            return stepSpecificationRegistry;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scenario");
        return null;
    }

    @Override
    public void setScenario(@org.jetbrains.annotations.NotNull StepSpecificationRegistry stepSpecificationRegistry) {
        Intrinsics.checkNotNullParameter((Object)stepSpecificationRegistry, (String)"<set-?>");
        this.scenario = stepSpecificationRegistry;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public String getDirectedAcyclicGraphName() {
        return this.directedAcyclicGraphName;
    }

    @Override
    public void setDirectedAcyclicGraphName(@org.jetbrains.annotations.NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.directedAcyclicGraphName = string;
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Duration duration) {
        this.timeout = duration;
    }

    @Override
    public long getIterations() {
        return this.iterations;
    }

    public void setIterations(long l) {
        this.iterations = l;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public Duration getIterationPeriods() {
        return this.iterationPeriods;
    }

    public void setIterationPeriods(@org.jetbrains.annotations.NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.iterationPeriods = duration;
    }

    @Override
    public boolean getStopIterationsOnError() {
        return this.stopIterationsOnError;
    }

    public void setStopIterationsOnError(boolean bl) {
        this.stopIterationsOnError = bl;
    }

    @Override
    @Nullable
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public List<StepSpecification<?, ?, ?>> getNextSteps() {
        return this.nextSteps;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public StepReportingSpecification getReporting() {
        return this.reporting;
    }

    @Override
    public void setReporting(@org.jetbrains.annotations.NotNull StepReportingSpecification stepReportingSpecification) {
        Intrinsics.checkNotNullParameter((Object)stepReportingSpecification, (String)"<set-?>");
        this.reporting = stepReportingSpecification;
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(@org.jetbrains.annotations.NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.tags = map2;
    }

    @Override
    public void timeout(@org.jetbrains.annotations.NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.setTimeout(duration);
    }

    @Override
    public void retry(@org.jetbrains.annotations.NotNull RetryPolicy retryPolicy) {
        Intrinsics.checkNotNullParameter((Object)retryPolicy, (String)"retryPolicy");
        this.setRetryPolicy(retryPolicy);
    }

    @Override
    public void iterate(long iterations, @org.jetbrains.annotations.NotNull Duration period, boolean stopOnError) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        this.setIterations(iterations);
        this.setIterationPeriods(period);
        this.setStopIterationsOnError(stopOnError);
    }

    @Override
    public void add(@org.jetbrains.annotations.NotNull StepSpecification<?, ?, ?> step2) {
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter(step2, (String)"step");
                if (step2.getTags().isEmpty()) break block3;
                AbstractStepSpecification abstractStepSpecification = step2 instanceof AbstractStepSpecification ? (AbstractStepSpecification)step2 : null;
                if (abstractStepSpecification != null ? abstractStepSpecification.tagsSet : false) break block4;
            }
            step2.tag(this.getTags());
        }
        this.getNextSteps().add(step2);
        this.getScenario().registerNext(this, step2);
    }

    @Override
    public void report(@org.jetbrains.annotations.NotNull @ExtensionFunctionType Function1<? super StepReportingSpecification, Unit> specification) {
        Intrinsics.checkNotNullParameter(specification, (String)"specification");
        specification.invoke((Object)this.getReporting());
    }

    @Override
    public void tag(@org.jetbrains.annotations.NotNull Map<String, String> tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.tagsSet = true;
        this.setTags(tags);
    }

    @Override
    public void timeout(long duration) {
        ConfigurableStepSpecification.DefaultImpls.timeout(this, duration);
    }

    @Override
    public void tag(Pair<String, String> ... tags) {
        ConfigurableStepSpecification.DefaultImpls.tag(this, tags);
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public StepSpecification<INPUT, OUTPUT, ?> configure(@org.jetbrains.annotations.NotNull @ExtensionFunctionType Function1<? super SELF, Unit> specification) {
        return ConfigurableStepSpecification.DefaultImpls.configure(this, specification);
    }

    @Override
    @org.jetbrains.annotations.NotNull
    public SELF split(@org.jetbrains.annotations.NotNull @ExtensionFunctionType Function1<? super StepSpecification<INPUT, OUTPUT, ?>, Unit> block) {
        return ConfigurableStepSpecification.DefaultImpls.split(this, block);
    }
}

