/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.executionprofile;

import io.qalipsis.api.executionprofile.ExecutionProfile;
import io.qalipsis.api.executionprofile.ExecutionProfileIterator;
import io.qalipsis.api.executionprofile.MinionsStartingLine;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\u001d\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/qalipsis/api/executionprofile/TimeFrameExecutionProfile;", "Lio/qalipsis/api/executionprofile/ExecutionProfile;", "periodInMs", "", "timeFrameInMs", "(JJ)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "iterator", "Lio/qalipsis/api/executionprofile/TimeFrameExecutionProfile$TimeFrameExecutionProfileIterator;", "totalMinionsCount", "speedFactor", "", "toString", "", "TimeFrameExecutionProfileIterator", "qalipsis-api-dsl"})
public final class TimeFrameExecutionProfile
implements ExecutionProfile {
    private final long periodInMs;
    private final long timeFrameInMs;

    public TimeFrameExecutionProfile(long periodInMs, long timeFrameInMs) {
        this.periodInMs = periodInMs;
        this.timeFrameInMs = timeFrameInMs;
    }

    @Override
    @NotNull
    public TimeFrameExecutionProfileIterator iterator(int totalMinionsCount, double speedFactor) {
        return new TimeFrameExecutionProfileIterator((long)((double)this.periodInMs / speedFactor), (long)((double)this.timeFrameInMs / speedFactor), totalMinionsCount);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.qalipsis.api.executionprofile.TimeFrameExecutionProfile");
        TimeFrameExecutionProfile cfr_ignored_0 = (TimeFrameExecutionProfile)other;
        if (this.periodInMs != ((TimeFrameExecutionProfile)other).periodInMs) {
            return false;
        }
        return this.timeFrameInMs == ((TimeFrameExecutionProfile)other).timeFrameInMs;
    }

    public int hashCode() {
        int result = Long.hashCode(this.periodInMs);
        result = 31 * result + Long.hashCode(this.timeFrameInMs);
        return result;
    }

    @Override
    public void notifyStart(double speedFactor) {
        ExecutionProfile.DefaultImpls.notifyStart(this, speedFactor);
    }

    @Override
    public boolean canReplay(@NotNull Duration minionExecutionDuration) {
        return ExecutionProfile.DefaultImpls.canReplay(this, minionExecutionDuration);
    }

    private final long component1() {
        return this.periodInMs;
    }

    private final long component2() {
        return this.timeFrameInMs;
    }

    @NotNull
    public final TimeFrameExecutionProfile copy(long periodInMs, long timeFrameInMs) {
        return new TimeFrameExecutionProfile(periodInMs, timeFrameInMs);
    }

    public static /* synthetic */ TimeFrameExecutionProfile copy$default(TimeFrameExecutionProfile timeFrameExecutionProfile, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l = timeFrameExecutionProfile.periodInMs;
        }
        if ((n & 2) != 0) {
            l2 = timeFrameExecutionProfile.timeFrameInMs;
        }
        return timeFrameExecutionProfile.copy(l, l2);
    }

    @NotNull
    public String toString() {
        return "TimeFrameExecutionProfile(periodInMs=" + this.periodInMs + ", timeFrameInMs=" + this.timeFrameInMs + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/qalipsis/api/executionprofile/TimeFrameExecutionProfile$TimeFrameExecutionProfileIterator;", "Lio/qalipsis/api/executionprofile/ExecutionProfileIterator;", "periodInMs", "", "timeFrameInMs", "totalMinionsCount", "", "(Lio/qalipsis/api/executionprofile/TimeFrameExecutionProfile;JJI)V", "minionsCountPerLaunch", "numberOfLaunches", "remainingMinions", "hasNext", "", "next", "Lio/qalipsis/api/executionprofile/MinionsStartingLine;", "qalipsis-api-dsl"})
    public final class TimeFrameExecutionProfileIterator
    implements ExecutionProfileIterator {
        private final long periodInMs;
        private int remainingMinions;
        private final long numberOfLaunches;
        private final int minionsCountPerLaunch;

        public TimeFrameExecutionProfileIterator(long periodInMs, long timeFrameInMs, int totalMinionsCount) {
            this.periodInMs = periodInMs;
            this.remainingMinions = totalMinionsCount;
            this.numberOfLaunches = timeFrameInMs / this.periodInMs;
            this.minionsCountPerLaunch = (int)Math.ceil((double)totalMinionsCount / (double)this.numberOfLaunches);
        }

        @Override
        @NotNull
        public MinionsStartingLine next() {
            int minionsCount = RangesKt.coerceAtMost((int)this.minionsCountPerLaunch, (int)this.remainingMinions);
            this.remainingMinions -= minionsCount;
            return new MinionsStartingLine(minionsCount, this.periodInMs);
        }

        @Override
        public boolean hasNext() {
            return this.remainingMinions > 0;
        }
    }
}

