/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.executionprofile;

import io.qalipsis.api.executionprofile.CompletionMode;
import io.qalipsis.api.executionprofile.ExecutionProfile;
import io.qalipsis.api.executionprofile.ExecutionProfileIterator;
import io.qalipsis.api.executionprofile.MinionsStartingLine;
import io.qalipsis.api.executionprofile.Stage;
import io.qalipsis.api.executionprofile.StageExecutionProfile$special$;
import io.qalipsis.api.logging.LoggerHelper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/qalipsis/api/executionprofile/StageExecutionProfile;", "Lio/qalipsis/api/executionprofile/ExecutionProfile;", "completion", "Lio/qalipsis/api/executionprofile/CompletionMode;", "stages", "", "Lio/qalipsis/api/executionprofile/Stage;", "(Lio/qalipsis/api/executionprofile/CompletionMode;Ljava/util/List;)V", "latestStageEnd", "", "canReplay", "", "minionExecutionDuration", "Ljava/time/Duration;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "iterator", "Lio/qalipsis/api/executionprofile/StageExecutionProfile$StageExecutionProfileIterator;", "totalMinionsCount", "speedFactor", "", "notifyStart", "", "toString", "", "Companion", "StageExecutionProfileIterator", "qalipsis-api-dsl"})
@SourceDebugExtension(value={"SMAP\nStageExecutionProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StageExecutionProfile.kt\nio/qalipsis/api/executionprofile/StageExecutionProfile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerHelper.kt\nio/qalipsis/api/logging/LoggerHelper\n*L\n1#1,181:1\n1#2:182\n34#3:183\n*S KotlinDebug\n*F\n+ 1 StageExecutionProfile.kt\nio/qalipsis/api/executionprofile/StageExecutionProfile\n*L\n154#1:183\n*E\n"})
public final class StageExecutionProfile
implements ExecutionProfile {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletionMode completion;
    @NotNull
    private final List<Stage> stages;
    private long latestStageEnd;
    @NotNull
    private static final KLogger log;

    public StageExecutionProfile(@NotNull CompletionMode completion, @NotNull List<Stage> stages) {
        Intrinsics.checkNotNullParameter((Object)((Object)completion), (String)"completion");
        Intrinsics.checkNotNullParameter(stages, (String)"stages");
        this.completion = completion;
        this.stages = stages;
        this.latestStageEnd = Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void notifyStart(double speedFactor) {
        if (this.latestStageEnd == Long.MIN_VALUE) {
            Iterable iterable = this.stages;
            long l = 0L;
            for (Object t : iterable) {
                void it;
                Stage stage = (Stage)t;
                long l2 = l;
                boolean bl = false;
                long l3 = it.getTotalDurationMs();
                l = l2 + l3;
            }
            double delayUntilEnd = (double)l / speedFactor;
            this.latestStageEnd = Instant.now().plusMillis((long)delayUntilEnd).toEpochMilli();
            log.debug((Function0)new Function0<Object>(this){
                final /* synthetic */ StageExecutionProfile this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "The latest stage ends at " + StageExecutionProfile.access$getLatestStageEnd$p(this.this$0);
                }
            });
            ExecutionProfile.DefaultImpls.notifyStart(this, speedFactor);
        }
    }

    @Override
    @NotNull
    public StageExecutionProfileIterator iterator(int totalMinionsCount, double speedFactor) {
        log.debug((Function0)new Function0<Object>(this){
            final /* synthetic */ StageExecutionProfile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Stages of the profile: " + StageExecutionProfile.access$getStages$p(this.this$0);
            }
        });
        return new StageExecutionProfileIterator(totalMinionsCount, speedFactor, (Collection<Stage>)this.stages);
    }

    @Override
    public boolean canReplay(@NotNull Duration minionExecutionDuration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)minionExecutionDuration, (String)"minionExecutionDuration");
        boolean it = bl = this.completion == CompletionMode.HARD ? this.latestStageEnd - System.currentTimeMillis() > minionExecutionDuration.toMillis() : this.latestStageEnd > System.currentTimeMillis();
        boolean bl2 = false;
        log.trace((Function0)new Function0<Object>(it, this, minionExecutionDuration){
            final /* synthetic */ boolean $it;
            final /* synthetic */ StageExecutionProfile this$0;
            final /* synthetic */ Duration $minionExecutionDuration;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                this.$minionExecutionDuration = $minionExecutionDuration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String choice = this.$it ? "" : "not";
                Instant end = Instant.ofEpochMilli(StageExecutionProfile.access$getLatestStageEnd$p(this.this$0));
                return "A minion running for " + this.$minionExecutionDuration + " can" + choice + " be replayed until " + end + " in the completion mode " + StageExecutionProfile.access$getCompletion$p(this.this$0);
            }
        });
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.qalipsis.api.executionprofile.StageExecutionProfile");
        StageExecutionProfile cfr_ignored_0 = (StageExecutionProfile)other;
        if (!Intrinsics.areEqual(this.stages, ((StageExecutionProfile)other).stages)) {
            return false;
        }
        return this.completion == ((StageExecutionProfile)other).completion;
    }

    public int hashCode() {
        int result = ((Object)this.stages).hashCode();
        result = 31 * result + this.completion.hashCode();
        return result;
    }

    private final CompletionMode component1() {
        return this.completion;
    }

    private final List<Stage> component2() {
        return this.stages;
    }

    @NotNull
    public final StageExecutionProfile copy(@NotNull CompletionMode completion, @NotNull List<Stage> stages) {
        Intrinsics.checkNotNullParameter((Object)((Object)completion), (String)"completion");
        Intrinsics.checkNotNullParameter(stages, (String)"stages");
        return new StageExecutionProfile(completion, stages);
    }

    public static /* synthetic */ StageExecutionProfile copy$default(StageExecutionProfile stageExecutionProfile, CompletionMode completionMode, List list, int n, Object object) {
        if ((n & 1) != 0) {
            completionMode = stageExecutionProfile.completion;
        }
        if ((n & 2) != 0) {
            list = stageExecutionProfile.stages;
        }
        return stageExecutionProfile.copy(completionMode, list);
    }

    @NotNull
    public String toString() {
        return "StageExecutionProfile(completion=" + this.completion + ", stages=" + this.stages + ")";
    }

    public static final /* synthetic */ long access$getLatestStageEnd$p(StageExecutionProfile $this) {
        return $this.latestStageEnd;
    }

    public static final /* synthetic */ List access$getStages$p(StageExecutionProfile $this) {
        return $this.stages;
    }

    public static final /* synthetic */ CompletionMode access$getCompletion$p(StageExecutionProfile $this) {
        return $this.completion;
    }

    static {
        LoggerHelper loggerHelper = LoggerHelper.INSTANCE;
        Companion $this$logger$iv = Companion;
        boolean $i$f$logger = false;
        log = KotlinLogging.INSTANCE.logger((Function0)special$$inlined$logger$1.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/qalipsis/api/executionprofile/StageExecutionProfile$Companion;", "", "()V", "log", "Lmu/KLogger;", "getLog", "()Lmu/KLogger;", "qalipsis-api-dsl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/qalipsis/api/executionprofile/StageExecutionProfile$StageExecutionProfileIterator;", "Lio/qalipsis/api/executionprofile/ExecutionProfileIterator;", "remainingMinionsGlobally", "", "speedFactor", "", "stages", "", "Lio/qalipsis/api/executionprofile/Stage;", "(Lio/qalipsis/api/executionprofile/StageExecutionProfile;IDLjava/util/Collection;)V", "startingLines", "", "Lio/qalipsis/api/executionprofile/MinionsStartingLine;", "getStartingLines", "", "hasNext", "", "next", "qalipsis-api-dsl"})
    @SourceDebugExtension(value={"SMAP\nStageExecutionProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StageExecutionProfile.kt\nio/qalipsis/api/executionprofile/StageExecutionProfile$StageExecutionProfileIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n959#2,7:182\n1559#2:189\n1590#2,4:190\n*S KotlinDebug\n*F\n+ 1 StageExecutionProfile.kt\nio/qalipsis/api/executionprofile/StageExecutionProfile$StageExecutionProfileIterator\n*L\n117#1:182,7\n119#1:189\n119#1:190,4\n*E\n"})
    public final class StageExecutionProfileIterator
    implements ExecutionProfileIterator {
        private int remainingMinionsGlobally;
        private final double speedFactor;
        @NotNull
        private final Collection<Stage> stages;
        @NotNull
        private final List<MinionsStartingLine> startingLines;

        public StageExecutionProfileIterator(int remainingMinionsGlobally, @NotNull double speedFactor, Collection<Stage> stages) {
            Intrinsics.checkNotNullParameter(stages, (String)"stages");
            this.remainingMinionsGlobally = remainingMinionsGlobally;
            this.speedFactor = speedFactor;
            this.stages = stages;
            this.startingLines = CollectionsKt.toMutableList((Collection)this.getStartingLines());
        }

        /*
         * WARNING - void declaration
         */
        private final List<MinionsStartingLine> getStartingLines() {
            List list;
            long stageStartOffset = 0L;
            Iterable iterable = this.stages;
            Collection collection = new ArrayList();
            int n = 0;
            for (Object t : iterable) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Iterable $this$takeWhile$iv;
                void stage;
                int n2;
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Stage stage2 = (Stage)t;
                int stageIndex = n2;
                boolean bl = false;
                long linesCount = stage.getRampUpDurationMs() / stage.getResolutionMs();
                Ref.IntRef remainingMinionsForCurrentStage = new Ref.IntRef();
                remainingMinionsForCurrentStage.element = RangesKt.coerceAtMost((int)stage.getMinionsCount(), (int)this.remainingMinionsGlobally);
                Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, remainingMinionsForCurrentStage){
                    final /* synthetic */ int $stageIndex;
                    final /* synthetic */ Ref.IntRef $remainingMinionsForCurrentStage;
                    {
                        this.$stageIndex = $stageIndex;
                        this.$remainingMinionsForCurrentStage = $remainingMinionsForCurrentStage;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Stage " + this.$stageIndex + ": " + this.$remainingMinionsForCurrentStage.element + " remaining minions";
                    }
                });
                int minionsByLine = (int)Math.ceil((double)stage.getMinionsCount() / (double)linesCount);
                Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, minionsByLine){
                    final /* synthetic */ int $stageIndex;
                    final /* synthetic */ int $minionsByLine;
                    {
                        this.$stageIndex = $stageIndex;
                        this.$minionsByLine = $minionsByLine;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Stage " + this.$stageIndex + ": " + this.$minionsByLine + " minions by starting line";
                    }
                });
                long maxStartingLines = (long)Math.ceil((double)remainingMinionsForCurrentStage.element / (double)minionsByLine);
                long delayBetweenLines = (long)((double)stage.getResolutionMs() / this.speedFactor);
                long stageStartingClockTime = 0L;
                Iterable iterable2 = (Iterable)new LongRange(1L, RangesKt.coerceAtMost((long)linesCount, (long)maxStartingLines));
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    long it = ((Number)item$iv).longValue();
                    boolean bl2 = false;
                    if (!(remainingMinionsForCurrentStage.element > 0 && this.remainingMinionsGlobally > 0)) break;
                    list$iv.add(item$iv);
                }
                $this$takeWhile$iv = list$iv;
                boolean $i$f$mapIndexed = false;
                list$iv = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index;
                    int n3;
                    if ((n3 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ((Number)item$iv$iv).longValue();
                    int n4 = n3;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, (int)index, remainingMinionsForCurrentStage, this){
                        final /* synthetic */ int $stageIndex;
                        final /* synthetic */ int $index;
                        final /* synthetic */ Ref.IntRef $remainingMinionsForCurrentStage;
                        final /* synthetic */ StageExecutionProfileIterator this$0;
                        {
                            this.$stageIndex = $stageIndex;
                            this.$index = $index;
                            this.$remainingMinionsForCurrentStage = $remainingMinionsForCurrentStage;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Stage " + this.$stageIndex + ", starting line " + this.$index + ": " + this.$remainingMinionsForCurrentStage.element + " remaining minions in stage, " + StageExecutionProfileIterator.access$getRemainingMinionsGlobally$p(this.this$0) + " remaining minions globally";
                        }
                    });
                    int minionsCountToStart = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)minionsByLine, (int)remainingMinionsForCurrentStage.element), (int)this.remainingMinionsGlobally);
                    Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, (int)index, minionsCountToStart){
                        final /* synthetic */ int $stageIndex;
                        final /* synthetic */ int $index;
                        final /* synthetic */ int $minionsCountToStart;
                        {
                            this.$stageIndex = $stageIndex;
                            this.$index = $index;
                            this.$minionsCountToStart = $minionsCountToStart;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Stage " + this.$stageIndex + ", starting line " + this.$index + ": " + this.$minionsCountToStart + " minions to start";
                        }
                    });
                    remainingMinionsForCurrentStage.element -= minionsCountToStart;
                    this.remainingMinionsGlobally -= minionsCountToStart;
                    long nextStart = index == false ? stageStartOffset : delayBetweenLines;
                    stageStartingClockTime += delayBetweenLines;
                    collection2.add(new MinionsStartingLine(minionsCountToStart, nextStart));
                }
                List stageResult2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                stageStartOffset = (long)((double)stage.getTotalDurationMs() / this.speedFactor) - stageStartingClockTime;
                CollectionsKt.addAll((Collection)collection, (Iterable)stageResult2);
            }
            List it = list = (List)collection;
            boolean bl = false;
            if (Companion.getLog().isTraceEnabled()) {
                Companion.getLog().trace((Function0)new Function0<Object>((List<MinionsStartingLine>)it){
                    final /* synthetic */ List<MinionsStartingLine> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Starting lines (count: " + this.$it.size() + "): " + this.$it;
                    }
                });
            } else {
                Companion.getLog().debug((Function0)new Function0<Object>((List<MinionsStartingLine>)it){
                    final /* synthetic */ List<MinionsStartingLine> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$it.size() + " starting lines were set, ending in " + ((MinionsStartingLine)CollectionsKt.last(this.$it)).getOffsetMs() + " milliseconds";
                    }
                });
            }
            return list;
        }

        @Override
        @NotNull
        public MinionsStartingLine next() {
            return (MinionsStartingLine)CollectionsKt.removeFirst(this.startingLines);
        }

        @Override
        public boolean hasNext() {
            return !((Collection)this.startingLines).isEmpty();
        }

        public static final /* synthetic */ int access$getRemainingMinionsGlobally$p(StageExecutionProfileIterator $this) {
            return $this.remainingMinionsGlobally;
        }
    }
}

