/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.executionprofile;

import io.qalipsis.api.executionprofile.ExecutionProfile;
import io.qalipsis.api.executionprofile.ExecutionProfileIterator;
import io.qalipsis.api.executionprofile.MinionsStartingLine;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u001c\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/qalipsis/api/executionprofile/RegularExecutionProfile;", "Lio/qalipsis/api/executionprofile/ExecutionProfile;", "periodInMs", "", "minionsCountProLaunch", "", "(JI)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "iterator", "Lio/qalipsis/api/executionprofile/RegularExecutionProfile$RegularExecutionProfileIterator;", "totalMinionsCount", "speedFactor", "", "toString", "", "RegularExecutionProfileIterator", "qalipsis-api-dsl"})
public final class RegularExecutionProfile
implements ExecutionProfile {
    private final long periodInMs;
    private final int minionsCountProLaunch;

    public RegularExecutionProfile(long periodInMs, int minionsCountProLaunch) {
        this.periodInMs = periodInMs;
        this.minionsCountProLaunch = minionsCountProLaunch;
    }

    @Override
    @NotNull
    public RegularExecutionProfileIterator iterator(int totalMinionsCount, double speedFactor) {
        return new RegularExecutionProfileIterator((long)((double)this.periodInMs / speedFactor), this.minionsCountProLaunch, totalMinionsCount);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.qalipsis.api.executionprofile.RegularExecutionProfile");
        RegularExecutionProfile cfr_ignored_0 = (RegularExecutionProfile)other;
        if (this.periodInMs != ((RegularExecutionProfile)other).periodInMs) {
            return false;
        }
        return this.minionsCountProLaunch == ((RegularExecutionProfile)other).minionsCountProLaunch;
    }

    public int hashCode() {
        int result = Long.hashCode(this.periodInMs);
        result = 31 * result + this.minionsCountProLaunch;
        return result;
    }

    @Override
    public void notifyStart(double speedFactor) {
        ExecutionProfile.DefaultImpls.notifyStart(this, speedFactor);
    }

    @Override
    public boolean canReplay(@NotNull Duration minionExecutionDuration) {
        return ExecutionProfile.DefaultImpls.canReplay(this, minionExecutionDuration);
    }

    private final long component1() {
        return this.periodInMs;
    }

    private final int component2() {
        return this.minionsCountProLaunch;
    }

    @NotNull
    public final RegularExecutionProfile copy(long periodInMs, int minionsCountProLaunch) {
        return new RegularExecutionProfile(periodInMs, minionsCountProLaunch);
    }

    public static /* synthetic */ RegularExecutionProfile copy$default(RegularExecutionProfile regularExecutionProfile, long l, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = regularExecutionProfile.periodInMs;
        }
        if ((n2 & 2) != 0) {
            n = regularExecutionProfile.minionsCountProLaunch;
        }
        return regularExecutionProfile.copy(l, n);
    }

    @NotNull
    public String toString() {
        return "RegularExecutionProfile(periodInMs=" + this.periodInMs + ", minionsCountProLaunch=" + this.minionsCountProLaunch + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/qalipsis/api/executionprofile/RegularExecutionProfile$RegularExecutionProfileIterator;", "Lio/qalipsis/api/executionprofile/ExecutionProfileIterator;", "periodInMs", "", "minionsCountProLaunch", "", "totalMinionsCount", "(Lio/qalipsis/api/executionprofile/RegularExecutionProfile;JII)V", "remainingMinions", "hasNext", "", "next", "Lio/qalipsis/api/executionprofile/MinionsStartingLine;", "qalipsis-api-dsl"})
    public final class RegularExecutionProfileIterator
    implements ExecutionProfileIterator {
        private final long periodInMs;
        private final int minionsCountProLaunch;
        private int remainingMinions;

        public RegularExecutionProfileIterator(long periodInMs, int minionsCountProLaunch, int totalMinionsCount) {
            this.periodInMs = periodInMs;
            this.minionsCountProLaunch = minionsCountProLaunch;
            this.remainingMinions = totalMinionsCount;
        }

        @Override
        @NotNull
        public MinionsStartingLine next() {
            int minionsCount = RangesKt.coerceAtMost((int)this.minionsCountProLaunch, (int)this.remainingMinions);
            this.remainingMinions -= minionsCount;
            return new MinionsStartingLine(minionsCount, this.periodInMs);
        }

        @Override
        public boolean hasNext() {
            return this.remainingMinions > 0;
        }
    }
}

