/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.executionprofile;

import io.qalipsis.api.executionprofile.ExecutionProfile;
import io.qalipsis.api.executionprofile.ExecutionProfileIterator;
import io.qalipsis.api.executionprofile.MinionsStartingLine;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u001c\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/qalipsis/api/executionprofile/ProgressiveVolumeExecutionProfile;", "Lio/qalipsis/api/executionprofile/ExecutionProfile;", "periodMs", "", "minionsCountProLaunchAtStart", "", "multiplier", "", "maxMinionsCountProLaunch", "(JIDI)V", "equals", "", "other", "", "hashCode", "iterator", "Lio/qalipsis/api/executionprofile/ProgressiveVolumeExecutionProfile$ProgressiveVolumeExecutionProfileIterator;", "totalMinionsCount", "speedFactor", "ProgressiveVolumeExecutionProfileIterator", "qalipsis-api-dsl"})
public final class ProgressiveVolumeExecutionProfile
implements ExecutionProfile {
    private final long periodMs;
    private final int minionsCountProLaunchAtStart;
    private final double multiplier;
    private final int maxMinionsCountProLaunch;

    public ProgressiveVolumeExecutionProfile(long periodMs, int minionsCountProLaunchAtStart, double multiplier, int maxMinionsCountProLaunch) {
        this.periodMs = periodMs;
        this.minionsCountProLaunchAtStart = minionsCountProLaunchAtStart;
        this.multiplier = multiplier;
        this.maxMinionsCountProLaunch = maxMinionsCountProLaunch;
    }

    @Override
    @NotNull
    public ProgressiveVolumeExecutionProfileIterator iterator(int totalMinionsCount, double speedFactor) {
        return new ProgressiveVolumeExecutionProfileIterator(this.periodMs, this.minionsCountProLaunchAtStart, this.multiplier * speedFactor, this.maxMinionsCountProLaunch, totalMinionsCount);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.qalipsis.api.executionprofile.ProgressiveVolumeExecutionProfile");
        ProgressiveVolumeExecutionProfile cfr_ignored_0 = (ProgressiveVolumeExecutionProfile)other;
        if (this.periodMs != ((ProgressiveVolumeExecutionProfile)other).periodMs) {
            return false;
        }
        if (this.minionsCountProLaunchAtStart != ((ProgressiveVolumeExecutionProfile)other).minionsCountProLaunchAtStart) {
            return false;
        }
        if (!(this.multiplier == ((ProgressiveVolumeExecutionProfile)other).multiplier)) {
            return false;
        }
        return this.maxMinionsCountProLaunch == ((ProgressiveVolumeExecutionProfile)other).maxMinionsCountProLaunch;
    }

    public int hashCode() {
        int result = Long.hashCode(this.periodMs);
        result = 31 * result + this.minionsCountProLaunchAtStart;
        result = 31 * result + Double.hashCode(this.multiplier);
        result = 31 * result + this.maxMinionsCountProLaunch;
        return result;
    }

    @Override
    public void notifyStart(double speedFactor) {
        ExecutionProfile.DefaultImpls.notifyStart(this, speedFactor);
    }

    @Override
    public boolean canReplay(@NotNull Duration minionExecutionDuration) {
        return ExecutionProfile.DefaultImpls.canReplay(this, minionExecutionDuration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/qalipsis/api/executionprofile/ProgressiveVolumeExecutionProfile$ProgressiveVolumeExecutionProfileIterator;", "Lio/qalipsis/api/executionprofile/ExecutionProfileIterator;", "periodMs", "", "minionsCountProLaunchAtStart", "", "multiplier", "", "maxMinionsCountProLaunch", "totalMinionsCount", "(Lio/qalipsis/api/executionprofile/ProgressiveVolumeExecutionProfile;JIDII)V", "nextVolume", "remainingMinions", "hasNext", "", "next", "Lio/qalipsis/api/executionprofile/MinionsStartingLine;", "qalipsis-api-dsl"})
    public final class ProgressiveVolumeExecutionProfileIterator
    implements ExecutionProfileIterator {
        private final long periodMs;
        private final double multiplier;
        private final int maxMinionsCountProLaunch;
        private int nextVolume;
        private int remainingMinions;

        public ProgressiveVolumeExecutionProfileIterator(long periodMs, int minionsCountProLaunchAtStart, double multiplier, int maxMinionsCountProLaunch, int totalMinionsCount) {
            this.periodMs = periodMs;
            this.multiplier = multiplier;
            this.maxMinionsCountProLaunch = maxMinionsCountProLaunch;
            this.nextVolume = minionsCountProLaunchAtStart;
            this.remainingMinions = totalMinionsCount;
        }

        @Override
        @NotNull
        public MinionsStartingLine next() {
            MinionsStartingLine result = new MinionsStartingLine(this.nextVolume, this.periodMs);
            this.remainingMinions -= this.nextVolume;
            this.nextVolume = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)((int)((double)this.nextVolume * this.multiplier)), (int)this.maxMinionsCountProLaunch), (int)this.remainingMinions);
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.remainingMinions > 0;
        }
    }
}

