/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.executionprofile;

import io.qalipsis.api.executionprofile.CompletionMode;
import io.qalipsis.api.executionprofile.ExecutionProfile;
import io.qalipsis.api.executionprofile.ExecutionProfileIterator;
import io.qalipsis.api.executionprofile.MinionsStartingLine;
import io.qalipsis.api.executionprofile.PercentageStage;
import io.qalipsis.api.executionprofile.PercentageStageExecutionProfile$special$;
import io.qalipsis.api.logging.LoggerHelper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c2\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/qalipsis/api/executionprofile/PercentageStageExecutionProfile;", "Lio/qalipsis/api/executionprofile/ExecutionProfile;", "completion", "Lio/qalipsis/api/executionprofile/CompletionMode;", "stages", "", "Lio/qalipsis/api/executionprofile/PercentageStage;", "(Lio/qalipsis/api/executionprofile/CompletionMode;Ljava/util/List;)V", "latestStageEnd", "", "canReplay", "", "minionExecutionDuration", "Ljava/time/Duration;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "iterator", "Lio/qalipsis/api/executionprofile/PercentageStageExecutionProfile$PercentStageExecutionProfileIterator;", "totalMinionsCount", "speedFactor", "", "notifyStart", "", "toString", "", "Companion", "PercentStageExecutionProfileIterator", "qalipsis-api-dsl"})
@SourceDebugExtension(value={"SMAP\nPercentageStageExecutionProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PercentageStageExecutionProfile.kt\nio/qalipsis/api/executionprofile/PercentageStageExecutionProfile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerHelper.kt\nio/qalipsis/api/logging/LoggerHelper\n*L\n1#1,268:1\n1#2:269\n34#3:270\n*S KotlinDebug\n*F\n+ 1 PercentageStageExecutionProfile.kt\nio/qalipsis/api/executionprofile/PercentageStageExecutionProfile\n*L\n175#1:270\n*E\n"})
public final class PercentageStageExecutionProfile
implements ExecutionProfile {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletionMode completion;
    @NotNull
    private final List<PercentageStage> stages;
    private long latestStageEnd;
    @NotNull
    private static final KLogger log;

    public PercentageStageExecutionProfile(@NotNull CompletionMode completion, @NotNull List<PercentageStage> stages) {
        Intrinsics.checkNotNullParameter((Object)((Object)completion), (String)"completion");
        Intrinsics.checkNotNullParameter(stages, (String)"stages");
        this.completion = completion;
        this.stages = stages;
        this.latestStageEnd = Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void notifyStart(double speedFactor) {
        if (this.latestStageEnd == Long.MIN_VALUE) {
            Iterable iterable = this.stages;
            long l = 0L;
            for (Object t : iterable) {
                void it;
                PercentageStage percentageStage = (PercentageStage)t;
                long l2 = l;
                boolean bl = false;
                long l3 = it.getTotalDurationMs();
                l = l2 + l3;
            }
            double delayUntilEnd = (double)l / speedFactor;
            this.latestStageEnd = Instant.now().plusMillis((long)delayUntilEnd).toEpochMilli();
            log.debug((Function0)new Function0<Object>(this){
                final /* synthetic */ PercentageStageExecutionProfile this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "The latest stage ends at " + PercentageStageExecutionProfile.access$getLatestStageEnd$p(this.this$0);
                }
            });
            ExecutionProfile.DefaultImpls.notifyStart(this, speedFactor);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PercentStageExecutionProfileIterator iterator(int totalMinionsCount, double speedFactor) {
        log.debug((Function0)new Function0<Object>(this){
            final /* synthetic */ PercentageStageExecutionProfile this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Stages of the profile: " + PercentageStageExecutionProfile.access$getStages$p(this.this$0);
            }
        });
        Iterable iterable = this.stages;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            PercentageStage percentageStage = (PercentageStage)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getMinionsPercentage();
            d = d2 + d3;
        }
        double percentageTotal = d;
        if (!(percentageTotal == 100.0)) {
            boolean bl = false;
            String string = "The sum of the percentages of all execution profile stages should be 100% but was " + percentageTotal + "%";
            throw new IllegalArgumentException(string.toString());
        }
        return new PercentStageExecutionProfileIterator(totalMinionsCount, speedFactor, (Collection<PercentageStage>)this.stages);
    }

    @Override
    public boolean canReplay(@NotNull Duration minionExecutionDuration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)minionExecutionDuration, (String)"minionExecutionDuration");
        boolean it = bl = this.completion == CompletionMode.HARD ? this.latestStageEnd - System.currentTimeMillis() > minionExecutionDuration.toMillis() : this.latestStageEnd > System.currentTimeMillis();
        boolean bl2 = false;
        log.trace((Function0)new Function0<Object>(it, this, minionExecutionDuration){
            final /* synthetic */ boolean $it;
            final /* synthetic */ PercentageStageExecutionProfile this$0;
            final /* synthetic */ Duration $minionExecutionDuration;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                this.$minionExecutionDuration = $minionExecutionDuration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                String choice = this.$it ? "" : "not";
                Instant end = Instant.ofEpochMilli(PercentageStageExecutionProfile.access$getLatestStageEnd$p(this.this$0));
                return "A minion running for " + this.$minionExecutionDuration + " can" + choice + " be replayed until " + end + " in the completion mode " + PercentageStageExecutionProfile.access$getCompletion$p(this.this$0);
            }
        });
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.qalipsis.api.executionprofile.PercentageStageExecutionProfile");
        PercentageStageExecutionProfile cfr_ignored_0 = (PercentageStageExecutionProfile)other;
        if (!Intrinsics.areEqual(this.stages, ((PercentageStageExecutionProfile)other).stages)) {
            return false;
        }
        return this.completion == ((PercentageStageExecutionProfile)other).completion;
    }

    public int hashCode() {
        int result = ((Object)this.stages).hashCode();
        result = 31 * result + this.completion.hashCode();
        return result;
    }

    private final CompletionMode component1() {
        return this.completion;
    }

    private final List<PercentageStage> component2() {
        return this.stages;
    }

    @NotNull
    public final PercentageStageExecutionProfile copy(@NotNull CompletionMode completion, @NotNull List<PercentageStage> stages) {
        Intrinsics.checkNotNullParameter((Object)((Object)completion), (String)"completion");
        Intrinsics.checkNotNullParameter(stages, (String)"stages");
        return new PercentageStageExecutionProfile(completion, stages);
    }

    public static /* synthetic */ PercentageStageExecutionProfile copy$default(PercentageStageExecutionProfile percentageStageExecutionProfile, CompletionMode completionMode, List list, int n, Object object) {
        if ((n & 1) != 0) {
            completionMode = percentageStageExecutionProfile.completion;
        }
        if ((n & 2) != 0) {
            list = percentageStageExecutionProfile.stages;
        }
        return percentageStageExecutionProfile.copy(completionMode, list);
    }

    @NotNull
    public String toString() {
        return "PercentageStageExecutionProfile(completion=" + this.completion + ", stages=" + this.stages + ")";
    }

    public static final /* synthetic */ long access$getLatestStageEnd$p(PercentageStageExecutionProfile $this) {
        return $this.latestStageEnd;
    }

    public static final /* synthetic */ List access$getStages$p(PercentageStageExecutionProfile $this) {
        return $this.stages;
    }

    public static final /* synthetic */ CompletionMode access$getCompletion$p(PercentageStageExecutionProfile $this) {
        return $this.completion;
    }

    static {
        LoggerHelper loggerHelper = LoggerHelper.INSTANCE;
        Companion $this$logger$iv = Companion;
        boolean $i$f$logger = false;
        log = KotlinLogging.INSTANCE.logger((Function0)special$$inlined$logger$1.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/qalipsis/api/executionprofile/PercentageStageExecutionProfile$Companion;", "", "()V", "log", "Lmu/KLogger;", "getLog", "()Lmu/KLogger;", "qalipsis-api-dsl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/qalipsis/api/executionprofile/PercentageStageExecutionProfile$PercentStageExecutionProfileIterator;", "Lio/qalipsis/api/executionprofile/ExecutionProfileIterator;", "totalMinionsCount", "", "speedFactor", "", "stages", "", "Lio/qalipsis/api/executionprofile/PercentageStage;", "(Lio/qalipsis/api/executionprofile/PercentageStageExecutionProfile;IDLjava/util/Collection;)V", "startingLines", "", "Lio/qalipsis/api/executionprofile/MinionsStartingLine;", "getStartingLines", "", "hasNext", "", "next", "qalipsis-api-dsl"})
    @SourceDebugExtension(value={"SMAP\nPercentageStageExecutionProfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PercentageStageExecutionProfile.kt\nio/qalipsis/api/executionprofile/PercentageStageExecutionProfile$PercentStageExecutionProfileIterator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n959#2,7:269\n1559#2:276\n1590#2,4:277\n*S KotlinDebug\n*F\n+ 1 PercentageStageExecutionProfile.kt\nio/qalipsis/api/executionprofile/PercentageStageExecutionProfile$PercentStageExecutionProfileIterator\n*L\n128#1:269,7\n130#1:276\n130#1:277,4\n*E\n"})
    public final class PercentStageExecutionProfileIterator
    implements ExecutionProfileIterator {
        private final int totalMinionsCount;
        private final double speedFactor;
        @NotNull
        private final Collection<PercentageStage> stages;
        @NotNull
        private final List<MinionsStartingLine> startingLines;

        public PercentStageExecutionProfileIterator(int totalMinionsCount, @NotNull double speedFactor, Collection<PercentageStage> stages) {
            Intrinsics.checkNotNullParameter(stages, (String)"stages");
            this.totalMinionsCount = totalMinionsCount;
            this.speedFactor = speedFactor;
            this.stages = stages;
            this.startingLines = CollectionsKt.toMutableList((Collection)this.getStartingLines());
        }

        /*
         * WARNING - void declaration
         */
        private final List<MinionsStartingLine> getStartingLines() {
            List list;
            Ref.IntRef remainingMinionsGlobally = new Ref.IntRef();
            remainingMinionsGlobally.element = this.totalMinionsCount;
            long stageStartOffset = 0L;
            Iterable iterable = this.stages;
            Collection collection = new ArrayList();
            int n = 0;
            for (Object t : iterable) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Iterable $this$takeWhile$iv;
                void stage;
                int n2;
                if ((n2 = n++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                PercentageStage percentageStage = (PercentageStage)t;
                int stageIndex = n2;
                boolean bl = false;
                int linesCount = (int)(stage.getRampUpDurationMs() / stage.getResolutionMs());
                int specifiedStartedMinionInStage = (int)Math.ceil(stage.getMinionsPercentage() / (double)100 * (double)this.totalMinionsCount);
                Ref.IntRef remainingMinionsForCurrentStage = new Ref.IntRef();
                remainingMinionsForCurrentStage.element = RangesKt.coerceAtMost((int)specifiedStartedMinionInStage, (int)remainingMinionsGlobally.element);
                Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, remainingMinionsForCurrentStage){
                    final /* synthetic */ int $stageIndex;
                    final /* synthetic */ Ref.IntRef $remainingMinionsForCurrentStage;
                    {
                        this.$stageIndex = $stageIndex;
                        this.$remainingMinionsForCurrentStage = $remainingMinionsForCurrentStage;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Stage " + this.$stageIndex + ": " + this.$remainingMinionsForCurrentStage.element + " remaining minions";
                    }
                });
                int minionsByLine = RangesKt.coerceAtLeast((int)((int)Math.rint((double)specifiedStartedMinionInStage / (double)linesCount)), (int)1);
                Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, minionsByLine){
                    final /* synthetic */ int $stageIndex;
                    final /* synthetic */ int $minionsByLine;
                    {
                        this.$stageIndex = $stageIndex;
                        this.$minionsByLine = $minionsByLine;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Stage " + this.$stageIndex + ": " + this.$minionsByLine + " minions by starting line";
                    }
                });
                int maxStartingLines = (int)Math.ceil((double)remainingMinionsForCurrentStage.element / (double)minionsByLine);
                long delayBetweenLines = (long)((double)stage.getResolutionMs() / this.speedFactor);
                long stageStartingClockTime = 0L;
                int actualNumberOfStartingLines = RangesKt.coerceAtMost((int)linesCount, (int)maxStartingLines);
                Iterable iterable2 = (Iterable)new IntRange(1, actualNumberOfStartingLines);
                boolean $i$f$takeWhile = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    int it = ((Number)item$iv).intValue();
                    boolean bl2 = false;
                    if (!(remainingMinionsForCurrentStage.element > 0 && remainingMinionsGlobally.element > 0)) break;
                    list$iv.add(item$iv);
                }
                $this$takeWhile$iv = list$iv;
                boolean $i$f$mapIndexed = false;
                list$iv = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void startingLineIndex;
                    int n3;
                    if ((n3 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ((Number)item$iv$iv).intValue();
                    int n4 = n3;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, (int)startingLineIndex, remainingMinionsForCurrentStage, remainingMinionsGlobally){
                        final /* synthetic */ int $stageIndex;
                        final /* synthetic */ int $startingLineIndex;
                        final /* synthetic */ Ref.IntRef $remainingMinionsForCurrentStage;
                        final /* synthetic */ Ref.IntRef $remainingMinionsGlobally;
                        {
                            this.$stageIndex = $stageIndex;
                            this.$startingLineIndex = $startingLineIndex;
                            this.$remainingMinionsForCurrentStage = $remainingMinionsForCurrentStage;
                            this.$remainingMinionsGlobally = $remainingMinionsGlobally;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Stage " + this.$stageIndex + ", starting line " + this.$startingLineIndex + ": " + this.$remainingMinionsForCurrentStage.element + " remaining minions in stage, " + this.$remainingMinionsGlobally.element + " remaining minions globally";
                        }
                    });
                    Ref.IntRef minionsCountToStart = new Ref.IntRef();
                    minionsCountToStart.element = RangesKt.coerceAtMost((int)RangesKt.coerceAtMost((int)minionsByLine, (int)remainingMinionsForCurrentStage.element), (int)remainingMinionsGlobally.element);
                    Companion.getLog().trace((Function0)new Function0<Object>(stageIndex, (int)startingLineIndex, minionsCountToStart){
                        final /* synthetic */ int $stageIndex;
                        final /* synthetic */ int $startingLineIndex;
                        final /* synthetic */ Ref.IntRef $minionsCountToStart;
                        {
                            this.$stageIndex = $stageIndex;
                            this.$startingLineIndex = $startingLineIndex;
                            this.$minionsCountToStart = $minionsCountToStart;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Stage " + this.$stageIndex + ", starting line " + this.$startingLineIndex + ": " + this.$minionsCountToStart.element + " minions to start";
                        }
                    });
                    remainingMinionsForCurrentStage.element -= minionsCountToStart.element;
                    remainingMinionsGlobally.element -= minionsCountToStart.element;
                    if (startingLineIndex == actualNumberOfStartingLines - 1 && remainingMinionsForCurrentStage.element > 0) {
                        int minionsToAdditionallyStart = RangesKt.coerceAtMost((int)remainingMinionsForCurrentStage.element, (int)remainingMinionsGlobally.element);
                        minionsCountToStart.element += minionsToAdditionallyStart;
                        remainingMinionsGlobally.element -= minionsToAdditionallyStart;
                    }
                    long nextStart = startingLineIndex == false ? stageStartOffset : delayBetweenLines;
                    stageStartingClockTime += delayBetweenLines;
                    collection2.add(new MinionsStartingLine(minionsCountToStart.element, nextStart));
                }
                List stageResult2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                stageStartOffset = (long)((double)stage.getTotalDurationMs() / this.speedFactor) - stageStartingClockTime;
                CollectionsKt.addAll((Collection)collection, (Iterable)stageResult2);
            }
            List it = list = (List)collection;
            boolean bl = false;
            if (Companion.getLog().isTraceEnabled()) {
                Companion.getLog().trace((Function0)new Function0<Object>((List<MinionsStartingLine>)it){
                    final /* synthetic */ List<MinionsStartingLine> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Starting lines (count: " + this.$it.size() + "): " + this.$it;
                    }
                });
            } else {
                Companion.getLog().debug((Function0)new Function0<Object>((List<MinionsStartingLine>)it){
                    final /* synthetic */ List<MinionsStartingLine> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$it.size() + " starting lines were set, ending in " + ((MinionsStartingLine)CollectionsKt.last(this.$it)).getOffsetMs() + " milliseconds";
                    }
                });
            }
            return list;
        }

        @Override
        @NotNull
        public MinionsStartingLine next() {
            return (MinionsStartingLine)CollectionsKt.removeFirst(this.startingLines);
        }

        @Override
        public boolean hasNext() {
            return !((Collection)this.startingLines).isEmpty();
        }
    }
}

