/*
 * Decompiled with CFR 0.152.
 */
package io.qalipsis.api.executionprofile;

import io.qalipsis.api.executionprofile.ExecutionProfile;
import io.qalipsis.api.executionprofile.ExecutionProfileIterator;
import io.qalipsis.api.executionprofile.MinionsStartingLine;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u00060\u0010R\u00020\u00002\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/qalipsis/api/executionprofile/AcceleratingExecutionProfile;", "Lio/qalipsis/api/executionprofile/ExecutionProfile;", "startPeriodMs", "", "accelerator", "", "minPeriodMs", "minionsCountProLaunch", "", "(JDJI)V", "equals", "", "other", "", "hashCode", "iterator", "Lio/qalipsis/api/executionprofile/AcceleratingExecutionProfile$AcceleratingExecutionProfileIterator;", "totalMinionsCount", "speedFactor", "AcceleratingExecutionProfileIterator", "qalipsis-api-dsl"})
public final class AcceleratingExecutionProfile
implements ExecutionProfile {
    private final long startPeriodMs;
    private final double accelerator;
    private final long minPeriodMs;
    private final int minionsCountProLaunch;

    public AcceleratingExecutionProfile(long startPeriodMs, double accelerator, long minPeriodMs, int minionsCountProLaunch) {
        this.startPeriodMs = startPeriodMs;
        this.accelerator = accelerator;
        this.minPeriodMs = minPeriodMs;
        this.minionsCountProLaunch = minionsCountProLaunch;
    }

    @Override
    @NotNull
    public AcceleratingExecutionProfileIterator iterator(int totalMinionsCount, double speedFactor) {
        return new AcceleratingExecutionProfileIterator(this.startPeriodMs, this.accelerator * speedFactor, this.minPeriodMs, this.minionsCountProLaunch, totalMinionsCount);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.qalipsis.api.executionprofile.AcceleratingExecutionProfile");
        AcceleratingExecutionProfile cfr_ignored_0 = (AcceleratingExecutionProfile)other;
        if (this.startPeriodMs != ((AcceleratingExecutionProfile)other).startPeriodMs) {
            return false;
        }
        if (!(this.accelerator == ((AcceleratingExecutionProfile)other).accelerator)) {
            return false;
        }
        if (this.minPeriodMs != ((AcceleratingExecutionProfile)other).minPeriodMs) {
            return false;
        }
        return this.minionsCountProLaunch == ((AcceleratingExecutionProfile)other).minionsCountProLaunch;
    }

    public int hashCode() {
        int result = Long.hashCode(this.startPeriodMs);
        result = 31 * result + Double.hashCode(this.accelerator);
        result = 31 * result + Long.hashCode(this.minPeriodMs);
        result = 31 * result + this.minionsCountProLaunch;
        return result;
    }

    @Override
    public void notifyStart(double speedFactor) {
        ExecutionProfile.DefaultImpls.notifyStart(this, speedFactor);
    }

    @Override
    public boolean canReplay(@NotNull Duration minionExecutionDuration) {
        return ExecutionProfile.DefaultImpls.canReplay(this, minionExecutionDuration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/qalipsis/api/executionprofile/AcceleratingExecutionProfile$AcceleratingExecutionProfileIterator;", "Lio/qalipsis/api/executionprofile/ExecutionProfileIterator;", "startPeriodMs", "", "accelerator", "", "minPeriodMs", "minionsCountProLaunch", "", "totalMinionsCount", "(Lio/qalipsis/api/executionprofile/AcceleratingExecutionProfile;JDJII)V", "divider", "nextPeriod", "remainingMinions", "hasNext", "", "next", "Lio/qalipsis/api/executionprofile/MinionsStartingLine;", "qalipsis-api-dsl"})
    public final class AcceleratingExecutionProfileIterator
    implements ExecutionProfileIterator {
        private final long minPeriodMs;
        private final int minionsCountProLaunch;
        private long nextPeriod;
        private double divider;
        private int remainingMinions;

        public AcceleratingExecutionProfileIterator(long startPeriodMs, double accelerator, long minPeriodMs, int minionsCountProLaunch, int totalMinionsCount) {
            this.minPeriodMs = minPeriodMs;
            this.minionsCountProLaunch = minionsCountProLaunch;
            this.nextPeriod = startPeriodMs;
            this.divider = RangesKt.coerceAtLeast((double)(1.0 / accelerator), (double)1.0E-12);
            this.remainingMinions = totalMinionsCount;
        }

        @Override
        @NotNull
        public MinionsStartingLine next() {
            int minionsCount = RangesKt.coerceAtMost((int)this.minionsCountProLaunch, (int)this.remainingMinions);
            this.remainingMinions -= minionsCount;
            MinionsStartingLine result = new MinionsStartingLine(minionsCount, this.nextPeriod);
            this.nextPeriod = RangesKt.coerceAtLeast((long)((long)((double)this.nextPeriod * this.divider)), (long)this.minPeriodMs);
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.remainingMinions > 0;
        }
    }
}

