/*
 * QALIPSIS
 * Copyright (C) 2025 AERIS IT Solutions GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package io.qalipsis.api.steps

import io.micronaut.core.annotation.Introspected
import io.qalipsis.api.context.StepContext

/**
 * Specification for a [io.qalipsis.core.factory.steps.MapWithContextStep].
 *
 * @author Eric Jessé
 */
@Introspected
data class MapWithContextStepSpecification<INPUT, OUTPUT>(
    val block: (context: StepContext<INPUT, OUTPUT>, input: INPUT) -> OUTPUT
) : AbstractStepSpecification<INPUT, OUTPUT, MapWithContextStepSpecification<INPUT, OUTPUT>>()

/**
 * Converts any input into a different output, also considering the context.
 *
 * @param block the rule to convert the input and the context into the output.
 *
 * @author Eric Jessé
 */
fun <INPUT, OUTPUT> StepSpecification<*, INPUT, *>.mapWithContext(
    @Suppress(
        "UNCHECKED_CAST"
    ) block: (context: StepContext<INPUT, OUTPUT>, input: INPUT) -> OUTPUT = { _, value -> value as OUTPUT }
): MapWithContextStepSpecification<INPUT, OUTPUT> {
    val step = MapWithContextStepSpecification(block)
    this.add(step)
    return step
}
