/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.polyglotted.common.util.Assertions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GeoPoint {
    private static final double EPSILON = 1.0E-7;
    private static final Pattern GEO_JSON = Pattern.compile("([-+]?[0-9]*\\.?[0-9]+)");
    public final double lat;
    public final double lon;

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && GeoPoint.doubleEquals(this.lat, ((GeoPoint)o).lat) && GeoPoint.doubleEquals(this.lon, ((GeoPoint)o).lon);
    }

    public int hashCode() {
        return Objects.hash(this.lat, this.lon);
    }

    public String toString() {
        return "[" + this.lon + "," + this.lat + "]";
    }

    @JsonCreator
    public static GeoPoint geoPointFromString(String value) {
        Matcher matcher = GEO_JSON.matcher(value);
        Assertions.checkBool(matcher.find(), "cannot find longitude");
        Double longitude = Double.parseDouble(matcher.group());
        Assertions.checkBool(matcher.find(), "cannot find longitude");
        Double latitude = Double.parseDouble(matcher.group());
        Assertions.checkBool(!matcher.find(), "no match found");
        return new GeoPoint(latitude, longitude);
    }

    private static boolean doubleEquals(double a, double b) {
        return a == b || Math.abs(a - b) < 1.0E-7;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public GeoPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }
}

