/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtil.class);

    public static boolean notInterrupted() {
        return !Thread.interrupted();
    }

    public static void stopThreadPool(ExecutorService threadPool) {
        ThreadUtil.stopThreadPool(threadPool, 10L, TimeUnit.SECONDS);
    }

    public static void stopThreadPool(ExecutorService threadPool, long time, TimeUnit unit) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(time, unit)) {
                threadPool.shutdownNow();
                threadPool.awaitTermination(time, unit);
            }
        }
        catch (InterruptedException ie) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static void safeSleep(long duration, TimeUnit unit) {
        ThreadUtil.safeSleep(unit.toMillis(duration));
    }

    public static void safeSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            log.debug("sleep interrupted");
        }
    }

    public static void safeAwait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupted waiting for latch");
        }
    }

    public static <T> T safeTake(BlockingQueue<T> queue) {
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupted taking from queue");
        }
    }
}

