/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.util.StrUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class AuthHeader {
    @Nullable
    public final String authHeader;

    public Header[] headers() {
        Header[] headerArray;
        if (StrUtil.nullOrEmpty(this.authHeader)) {
            headerArray = new Header[]{};
        } else {
            Header[] headerArray2 = new Header[1];
            headerArray = headerArray2;
            headerArray2[0] = new BasicHeader("Authorization", this.authHeader);
        }
        return headerArray;
    }

    public static AuthHeader basicAuth(String user, String passwd) {
        return new AuthHeader("Basic " + AuthHeader.b64Encode(user, passwd));
    }

    public static AuthHeader customAuth(String type, String user, String passwd) {
        return new AuthHeader(type + " " + AuthHeader.b64Encode(user, passwd));
    }

    public static AuthHeader bearerToken(String token) {
        return new AuthHeader("Bearer " + token);
    }

    public static AuthHeader authHeader(Object auth) {
        return new AuthHeader(auth == null ? null : String.valueOf(auth));
    }

    private static String b64Encode(String user, String creds) {
        return Base64.encodeBase64String((byte[])(user + ":" + creds).getBytes(StandardCharsets.UTF_8));
    }

    public AuthHeader(@Nullable String authHeader) {
        this.authHeader = authHeader;
    }
}

