/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.io.CharStreams;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.HttpRequestBuilder;
import io.polyglotted.common.util.MapRetriever;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static HttpRequestBuilder buildGet(String uri) {
        return HttpUtil.buildGet(uri, null);
    }

    public static HttpRequestBuilder buildGet(String uri, String path) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.GET, uri, path);
    }

    public static HttpRequestBuilder buildPost(String uri) {
        return HttpUtil.buildPost(uri, null);
    }

    public static HttpRequestBuilder buildPost(String uri, String path) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.POST, uri, path);
    }

    public static HttpRequestBuilder buildPut(String uri) {
        return HttpUtil.buildPut(uri, null);
    }

    public static HttpRequestBuilder buildPut(String uri, String path) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.PUT, uri, path);
    }

    public static HttpRequestBuilder buildDelete(String uri) {
        return HttpUtil.buildDelete(uri, null);
    }

    public static HttpRequestBuilder buildDelete(String uri, String path) {
        return new HttpRequestBuilder(HttpRequestBuilder.HttpReqType.DELETE, uri, path);
    }

    public static MapResult execute(HttpClient client, HttpRequestBuilder builder) {
        return HttpUtil.execute(client, builder.request());
    }

    public static <H extends HttpRequestBase> MapResult execute(HttpClient client, H post) {
        return MapResult.simpleResult(HttpUtil.execute(client, post, MapRetriever.MAP_CLASS));
    }

    public static <R> R execute(HttpClient client, HttpRequestBuilder builder, Class<R> clazz) {
        return HttpUtil.execute(client, builder.request(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <H extends HttpRequestBase, R> R execute(HttpClient client, H post, Class<R> clazz) {
        try {
            R r = BaseSerializer.deserialize(HttpUtil.executeRaw(client, post).getEntity().getContent(), clazz);
            return r;
        }
        finally {
            post.releaseConnection();
        }
    }

    public static String executePlain(HttpClient client, HttpRequestBuilder builder) {
        return HttpUtil.executePlain(client, builder.request());
    }

    public static <H extends HttpRequestBase> String executePlain(HttpClient client, H post) {
        String string;
        try {
            string = CharStreams.toString((Readable)new InputStreamReader(HttpUtil.executeRaw(client, post).getEntity().getContent(), StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return string;
    }

    public static HttpResponse executeRaw(HttpClient client, HttpRequestBuilder builder) {
        return HttpUtil.executeRaw(client, builder.request());
    }

    public static <H extends HttpRequestBase> HttpResponse executeRaw(HttpClient client, H post) {
        HttpResponse httpResponse;
        try {
            httpResponse = HttpUtil.checkStatus(client.execute(post));
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            throw throwable;
        }
        post.releaseConnection();
        return httpResponse;
    }

    private static HttpResponse checkStatus(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!Assertions.checkBetween(statusCode, 200L, 300L, true, false)) {
            String errorMessage = CharStreams.toString((Readable)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
            log.warn(errorMessage);
            throw new HttpClientException(statusCode, errorMessage);
        }
        return response;
    }

    public static class HttpClientException
    extends RuntimeException {
        public final int errorCode;

        public HttpClientException(int errorCode, String message) {
            super(message);
            this.errorCode = errorCode;
        }
    }
}

