/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.HttpConfig;
import io.polyglotted.common.util.HttpUtil;
import io.polyglotted.common.util.MapBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackPublisher
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SlackPublisher.class);
    private final CloseableHttpClient client;
    private final SlackConfig slackConfig;
    private final Pattern pattern;

    public SlackPublisher(SlackConfig slackConfig) {
        this(slackConfig, new HttpConfig());
    }

    public SlackPublisher(SlackConfig slackConfig, HttpConfig httpConfig) {
        this.client = HttpConfig.httpClient(httpConfig);
        this.slackConfig = slackConfig;
        this.pattern = Pattern.compile(slackConfig.filter);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public void publish(String route, MapResult attachment) {
        if (!this.slackConfig.enabled || !this.pattern.matcher(route).matches()) {
            return;
        }
        HttpPost post = new HttpPost(this.slackConfig.hookUrl);
        post.setEntity((HttpEntity)new StringEntity(BaseSerializer.serialize(MapBuilder.immutableMap("channel", this.slackConfig.channel, "username", attachment.get("author_name"), "attachments", Collections.singletonList(attachment), "icon_emoji", attachment.get("icon"))), ContentType.APPLICATION_JSON));
        HttpUtil.executePlain((HttpClient)this.client, post);
    }

    public static class SlackConfig {
        private boolean enabled = false;
        private String hookUrl = "";
        private String channel = "";
        private String filter = ".*";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getHookUrl() {
            return this.hookUrl;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getFilter() {
            return this.filter;
        }

        public SlackConfig setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SlackConfig setHookUrl(String hookUrl) {
            this.hookUrl = hookUrl;
            return this;
        }

        public SlackConfig setChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public SlackConfig setFilter(String filter) {
            this.filter = filter;
            return this;
        }
    }
}

