/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.net.InetAddresses;
import io.polyglotted.common.model.GeoHash;
import io.polyglotted.common.model.GeoPoint;
import io.polyglotted.common.util.DateFormatters;
import io.polyglotted.common.util.EncodingUtil;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.UuidUtil;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.UUID;

public abstract class ConversionUtil {
    private static final DateTimeFormatter ZDT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSz");

    public static boolean asBool(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return "true".equalsIgnoreCase((String)value);
        }
        throw new IllegalArgumentException("unknown boolean trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static byte[] asBinary(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof ByteBuffer) {
            return ((ByteBuffer)value).array();
        }
        if (value instanceof String) {
            return EncodingUtil.decodeBase64((String)value);
        }
        throw new IllegalArgumentException("unknown binary trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static ByteBuffer asBuffer(Object value) {
        if (value instanceof ByteBuffer) {
            return (ByteBuffer)value;
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        if (value instanceof String) {
            return ByteBuffer.wrap(EncodingUtil.decodeBase64((String)value));
        }
        throw new IllegalArgumentException("unknown buffer trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static GeoPoint asGeoPoint(Object value) {
        if (value instanceof GeoPoint) {
            return (GeoPoint)value;
        }
        if (value instanceof GeoHash) {
            return ((GeoHash)value).point;
        }
        if (value instanceof String) {
            return GeoPoint.geoPointFromString((String)value);
        }
        throw new IllegalArgumentException("unknown geopoint trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static String asBinaryString(Object value) {
        if (value instanceof ByteBuffer) {
            return EncodingUtil.encodeBase64(((ByteBuffer)value).array());
        }
        if (value instanceof byte[]) {
            return EncodingUtil.encodeBase64((byte[])value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("unknown binary trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static UUID asUuid(Object value) {
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return UuidUtil.uuidFrom(String.valueOf(value));
        }
        throw new IllegalArgumentException("unknown uuid trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static InetAddress asInetAddress(Object value) {
        if (value instanceof InetAddress) {
            return (InetAddress)value;
        }
        if (value instanceof String) {
            return InetAddresses.forString((String)((String)value));
        }
        throw new IllegalArgumentException("unknown ipaddress trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static URL asUrl(Object value) {
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof String) {
            return new URL((String)value);
        }
        throw new IllegalArgumentException("unknown url trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static URI asUri(Object value) {
        if (value instanceof URI) {
            return (URI)value;
        }
        if (value instanceof String) {
            return new URI((String)value);
        }
        throw new IllegalArgumentException("unknown uri trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static LocalDate asLocalDate(Object value) {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof String) {
            return DateFormatters.parseDate((String)value);
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant().atOffset(ZoneOffset.UTC).toLocalDate();
        }
        throw new IllegalArgumentException("unknown local date trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static LocalTime asLocalTime(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof OffsetTime) {
            return ((OffsetTime)value).toLocalTime();
        }
        if (value instanceof Integer) {
            return LocalTime.ofSecondOfDay(((Integer)value).longValue());
        }
        if (value instanceof Long) {
            return LocalTime.ofNanoOfDay((Long)value);
        }
        if (value instanceof String) {
            return DateFormatters.parseTime((String)value);
        }
        throw new IllegalArgumentException("unknown local time trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static OffsetTime asOffsetTime(Object value) {
        if (value instanceof OffsetTime) {
            return (OffsetTime)value;
        }
        if (value instanceof LocalTime) {
            return ((LocalTime)value).atOffset(ZoneOffset.UTC);
        }
        if (value instanceof String) {
            return DateFormatters.parseTime((String)value).atOffset(ZoneOffset.UTC);
        }
        throw new IllegalArgumentException("unknown offset time trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static String asZonedDateTimeString(Object value) {
        return ZDT_FORMATTER.format(ConversionUtil.asZonedDateTime(value));
    }

    public static ZonedDateTime asZonedDateTime(Object value) {
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atZone(ZoneOffset.UTC);
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toZonedDateTime();
        }
        if (value instanceof String) {
            return DateFormatters.parseDateTime((String)value);
        }
        if (value instanceof Long) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneOffset.UTC);
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant().atZone(ZoneOffset.UTC);
        }
        throw new IllegalArgumentException("unknown zoned datetime trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static OffsetDateTime asOffsetDateTime(Object value) {
        if (value instanceof OffsetDateTime) {
            return (OffsetDateTime)value;
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toOffsetDateTime();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).atOffset(ZoneOffset.UTC);
        }
        if (value instanceof String) {
            return DateFormatters.parseDateTime((String)value).toOffsetDateTime();
        }
        if (value instanceof Long) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneOffset.UTC);
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant().atOffset(ZoneOffset.UTC);
        }
        throw new IllegalArgumentException("unknown offset datetime trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static LocalDateTime asLocalDateTime(Object value) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        if (value instanceof String) {
            return DateFormatters.parseDateTime((String)value).toLocalDateTime();
        }
        if (value instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneOffset.UTC);
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant().atZone(ZoneOffset.UTC).toLocalDateTime();
        }
        throw new IllegalArgumentException("unknown local datetime trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static Date asDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof LocalDateTime) {
            return new Date(((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (value instanceof OffsetDateTime) {
            return new Date(((OffsetDateTime)value).toInstant().toEpochMilli());
        }
        if (value instanceof ZonedDateTime) {
            return new Date(((ZonedDateTime)value).toInstant().toEpochMilli());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            return new Date(DateFormatters.parseDateTime((String)value).toInstant().toEpochMilli());
        }
        throw new IllegalArgumentException("unknown date trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static long asEpoch(Object value) {
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toInstant().toEpochMilli();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toInstant().toEpochMilli();
        }
        if (value instanceof Long) {
            return new Date((Long)value).getTime();
        }
        if (value instanceof String) {
            return DateFormatters.parseDateTime((String)value).toInstant().toEpochMilli();
        }
        throw new IllegalArgumentException("unknown date trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static byte asByte(Object value) {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new IllegalArgumentException("unknown byte trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static short asShort(Object value) {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new IllegalArgumentException("unknown short trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static int asInt(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new IllegalArgumentException("unknown int trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static long asLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).longValueExact();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException nfe) {
                return DateFormatters.parseDateTime((String)value).toInstant().toEpochMilli();
            }
        }
        throw new IllegalArgumentException("unknown long trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static float asFloat(Object value) {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new IllegalArgumentException("unknown float trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static double asDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new IllegalArgumentException("unknown double trait " + value + ":" + ReflectionUtil.safeClass(value));
    }

    public static BigInteger asBigInt(Object value) {
        return value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(ConversionUtil.asLong(value));
    }
}

