/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class CommaUtil {
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private static final Splitter.MapSplitter EQUALS_SPLITTER = COMMA_SPLITTER.withKeyValueSeparator("=");
    private static final Joiner COMMA_JOINER = Joiner.on((String)",").skipNulls();

    public static Map<String, String> commaEqSplit(String value) {
        return EQUALS_SPLITTER.split((CharSequence)value);
    }

    public static Map<String, String> mapSplit(String value, String separator) {
        return CommaUtil.mapSplitter(separator).split((CharSequence)value);
    }

    public static Splitter.MapSplitter mapSplitter(String keyValueSeparator) {
        return COMMA_SPLITTER.withKeyValueSeparator(keyValueSeparator);
    }

    public static List<String> commaSplit(String value) {
        return value == null ? null : COMMA_SPLITTER.splitToList((CharSequence)value);
    }

    public static String commaJoin(Collection<String> values) {
        return values == null ? null : COMMA_JOINER.join(values);
    }
}

