/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import org.apache.commons.text.StringEscapeUtils;

public class WebException
extends RuntimeException {
    public final int httpStatus;

    public WebException(int httpStatus, String message) {
        this(httpStatus, message, null);
    }

    public WebException(int httpStatus, String message, Throwable cause) {
        super(StringEscapeUtils.escapeHtml4((String)message), cause);
        this.httpStatus = httpStatus;
    }

    public static WebException asInternalServerException(Throwable ex) {
        return ex.getCause() instanceof WebException ? (WebException)ex.getCause() : new WebException(500, ex.getMessage(), ex);
    }

    public static WebException internalServerException(String message, Throwable ex) {
        return new WebException(500, message, ex);
    }

    public static WebException internalServerException(String message) {
        return new WebException(500, message);
    }

    public static WebException badRequestException(String message) {
        return new WebException(400, message);
    }

    public static WebException forbiddenException(String message) {
        return new WebException(403, message);
    }

    public static WebException unauthorisedException(String message) {
        return new WebException(401, message);
    }

    public static WebException notFoundException(String item) {
        return new WebException(404, item + ": Not Found");
    }

    public static WebException methodNotAllowedException(String message) {
        return new WebException(405, message);
    }

    public static WebException conflictException(String message) {
        return new WebException(409, message);
    }

    public static void checkBadRequest(boolean condition, String message) {
        WebException.checkBadRequest(condition, message, null);
    }

    public static <T> T checkBadRequest(boolean condition, String message, T r) {
        if (!condition) {
            throw WebException.badRequestException(message);
        }
        return r;
    }
}

