/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.polyglotted.common.model.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathRouter<T> {
    static final Pattern GROUP_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final Pattern WILD_CARD_PATTERN = Pattern.compile("\\*\\*");
    private final int maxPathParts;
    private final List<Pair<Pattern, RouteDestinationWithGroups>> patternRouteList;

    public static <T> PathRouter<T> create(int maxPathParts) {
        return new PathRouter<T>(maxPathParts);
    }

    private PathRouter(int maxPathParts) {
        this.maxPathParts = maxPathParts;
        this.patternRouteList = Lists.newArrayList();
    }

    public void add(String source, T destination) {
        String path = source.replaceAll("/+", "/");
        path = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        String[] parts = path.split("/");
        if (parts.length - 1 > this.maxPathParts) {
            throw new IllegalArgumentException("Number of parts of path " + source + " exceeds allowed limit " + this.maxPathParts);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList groupNames = Lists.newArrayList();
        for (String part : parts) {
            Matcher groupMatcher = GROUP_PATTERN.matcher(part);
            if (groupMatcher.matches()) {
                groupNames.add(groupMatcher.group(1));
                sb.append("([^/]+?)");
            } else if (WILD_CARD_PATTERN.matcher(part).matches()) {
                sb.append(".*?");
            } else {
                sb.append(part);
            }
            sb.append("/");
        }
        sb.setLength(sb.length() - 1);
        Pattern pattern = Pattern.compile(sb.toString());
        this.patternRouteList.add(Pair.pair(pattern, new RouteDestinationWithGroups(destination, groupNames)));
    }

    public List<RoutableDestination<T>> getDestinations(String path) {
        String cleanPath = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        ArrayList result = Lists.newArrayList();
        for (Pair<Pattern, RouteDestinationWithGroups> patternRoute : this.patternRouteList) {
            ImmutableMap.Builder groupNameValuesBuilder = ImmutableMap.builder();
            Matcher matcher = ((Pattern)patternRoute._a).matcher(cleanPath);
            if (!matcher.matches()) continue;
            int matchIndex = 1;
            for (String name : ((RouteDestinationWithGroups)patternRoute._b).groupNames) {
                String value = matcher.group(matchIndex);
                groupNameValuesBuilder.put((Object)name, (Object)value);
                ++matchIndex;
            }
            result.add(new RoutableDestination(((RouteDestinationWithGroups)patternRoute._b).destination, (Map<String, String>)groupNameValuesBuilder.build()));
        }
        return result;
    }

    public static final class RoutableDestination<T> {
        public final T destination;
        public final Map<String, String> groupNameValues;

        public RoutableDestination(T destination, Map<String, String> groupNameValues) {
            this.destination = destination;
            this.groupNameValues = groupNameValues;
        }
    }

    private final class RouteDestinationWithGroups {
        final T destination;
        final List<String> groupNames;

        public String toString() {
            return "PathRouter.RouteDestinationWithGroups(destination=" + this.destination + ", groupNames=" + this.groupNames + ")";
        }

        public RouteDestinationWithGroups(T destination, List<String> groupNames) {
            this.destination = destination;
            this.groupNames = groupNames;
        }
    }
}

