/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.web.AbstractHttpHandler;
import io.polyglotted.common.web.HttpMethod;
import io.polyglotted.common.web.HttpRequest;
import io.polyglotted.common.web.HttpResponder;
import io.polyglotted.common.web.ParamConvertUtils;
import io.polyglotted.common.web.WebException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public final class HttpResourceModel {
    private static final Set<Class<? extends Annotation>> SUPPORTED_PARAM_ANNOTATIONS = ListBuilder.immutableSet(PathParam.class, QueryParam.class);
    private final Set<HttpMethod> httpMethods;
    private final String path;
    private final Method method;
    private final List<Map<Class<? extends Annotation>, ParameterInfo<?>>> paramsInfo;

    HttpResourceModel(Set<HttpMethod> httpMethods, String path, Method method) {
        this.httpMethods = httpMethods;
        this.path = path;
        this.method = method;
        this.paramsInfo = HttpResourceModel.createParametersInfos(method);
    }

    private static List<Map<Class<? extends Annotation>, ParameterInfo<?>>> createParametersInfos(Method method) {
        if (method.getParameterTypes().length <= 2) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        Type[] parameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 2; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            IdentityHashMap paramAnnotations = Maps.newIdentityHashMap();
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                ParameterInfo parameterInfo = PathParam.class.isAssignableFrom(annotationType) ? new ParameterInfo(annotation, ParamConvertUtils.createPathParamConverter(parameterTypes[i])) : (QueryParam.class.isAssignableFrom(annotationType) ? new ParameterInfo(annotation, ParamConvertUtils.createQueryParamConverter(parameterTypes[i])) : new ParameterInfo(annotation, null));
                paramAnnotations.put(annotationType, parameterInfo);
            }
            if (Sets.intersection(SUPPORTED_PARAM_ANNOTATIONS, paramAnnotations.keySet()).size() != 1) {
                throw new IllegalArgumentException(String.format("Must have exactly one annotation from %s for parameter %d in method %s", SUPPORTED_PARAM_ANNOTATIONS, i, method));
            }
            result.add(MapBuilder.immutableMap(paramAnnotations));
        }
        return result.build();
    }

    void handle(AbstractHttpHandler handler, HttpRequest request, HttpResponder responder, Map<String, String> groupValues) {
        try {
            Object[] args = new Object[this.paramsInfo.size() + 2];
            args[0] = request;
            args[1] = responder;
            int idx = 2;
            for (Map<Class<Annotation>, ParameterInfo<?>> info : this.paramsInfo) {
                if (info.containsKey(PathParam.class)) {
                    args[idx++] = HttpResourceModel.getPathParamValue(info, groupValues);
                    continue;
                }
                if (!info.containsKey(QueryParam.class)) continue;
                args[idx++] = HttpResourceModel.getQueryParamValue(info, request);
            }
            this.method.invoke((Object)handler, args);
        }
        catch (Throwable e) {
            String deepMessage = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
            throw WebException.internalServerException("Error in " + (Object)((Object)request.method) + " " + request.uriPath + ": " + deepMessage);
        }
    }

    private static Object getPathParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, Map<String, String> groupValues) {
        ParameterInfo<?> info = annotations.get(PathParam.class);
        PathParam pathParam = (PathParam)info.getAnnotation();
        String value = groupValues.get(pathParam.value());
        return info.convert(Objects.requireNonNull(value, "Could not resolve value for parameter " + pathParam.value()));
    }

    private static Object getQueryParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, HttpRequest request) {
        ParameterInfo<?> info = annotations.get(QueryParam.class);
        QueryParam queryParam = (QueryParam)info.getAnnotation();
        List values = request.queryParams.get((Object)queryParam.value());
        return values.isEmpty() ? info.convert(HttpResourceModel.defaultValue(annotations)) : info.convert(values);
    }

    private static List<String> defaultValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations) {
        ParameterInfo<?> defaultInfo = annotations.get(DefaultValue.class);
        return defaultInfo != null ? ListBuilder.immutableList(((DefaultValue)defaultInfo.getAnnotation()).value()) : ListBuilder.immutableList();
    }

    public String toString() {
        return "HttpResourceModel(httpMethods=" + this.httpMethods() + ", path=" + this.path() + ", method=" + this.method + ")";
    }

    public Set<HttpMethod> httpMethods() {
        return this.httpMethods;
    }

    public String path() {
        return this.path;
    }

    private static final class ParameterInfo<T> {
        private final Annotation annotation;
        private final Function<T, Object> converter;

        <V extends Annotation> V getAnnotation() {
            return (V)this.annotation;
        }

        Object convert(T input) {
            return this.converter == null ? null : this.converter.apply(input);
        }

        private ParameterInfo(Annotation annotation, Function<T, Object> converter) {
            this.annotation = annotation;
            this.converter = converter;
        }
    }
}

