/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Multimap;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.web.WebException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.http.impl.EnglishReasonPhraseCatalog;

@JsonAutoDetect
@JsonPropertyOrder(value={"statusCode", "statusDescription", "headers", "multiValueHeaders", "isBase64Encoded", "body"})
public class GatewayResponse {
    public final int statusCode;
    public final String statusDescription;
    public final boolean isBase64Encoded;
    public final String body;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Map<String, String> headers;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Multimap<String, String> multiValueHeaders;

    public static void sendError(boolean isLoadBalanced, OutputStream output, Exception ex) {
        GatewayResponse.sendResult(isLoadBalanced, output, ex instanceof WebException ? ((WebException)ex).httpStatus : 500, ex.getMessage(), false, MapBuilder.immutableMap("Content-Type", "text/plain; charset=utf-8"));
    }

    public static void sendResult(boolean isLoadBalanced, OutputStream output, int status, String result, boolean isBase64, Map<String, String> headers) {
        String desc = isLoadBalanced ? status + " " + EnglishReasonPhraseCatalog.INSTANCE.getReason(status, null) : null;
        Object multiHeaders = isLoadBalanced ? MapBuilder.immutableMultimap(headers) : MapBuilder.immutableMultimap();
        BaseSerializer.MAPPER.writeValue(output, (Object)new GatewayResponse(status, desc, isBase64, result, headers, (Multimap<String, String>)multiHeaders));
    }

    public GatewayResponse(int statusCode, String statusDescription, boolean isBase64Encoded, String body, Map<String, String> headers, Multimap<String, String> multiValueHeaders) {
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
        this.isBase64Encoded = isBase64Encoded;
        this.body = body;
        this.headers = headers;
        this.multiValueHeaders = multiValueHeaders;
    }
}

