/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.web.GatewayResponse;
import io.polyglotted.common.web.HttpMethod;
import io.polyglotted.common.web.HttpRequest;
import io.polyglotted.common.web.HttpResourceModel;
import io.polyglotted.common.web.HttpResponder;
import io.polyglotted.common.web.PathRouter;
import io.polyglotted.common.web.WebException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpHandler.class);
    private static final Splitter SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private final PathRouter<HttpResourceModel> patternRouter = PathRouter.create(25);

    protected AbstractHttpHandler() {
        String basePath = "";
        if (this.getClass().isAnnotationPresent(Path.class)) {
            basePath = this.getClass().getAnnotation(Path.class).value();
        }
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (method.getParameterTypes().length < 2 || !method.getParameterTypes()[0].isAssignableFrom(HttpRequest.class) || !method.getParameterTypes()[1].isAssignableFrom(HttpResponder.class) || !Modifier.isPublic(method.getModifiers())) continue;
            String relativePath = "";
            if (method.getAnnotation(Path.class) != null) {
                relativePath = method.getAnnotation(Path.class).value();
            }
            String absolutePath = basePath + "/" + relativePath;
            Set<HttpMethod> httpMethods = AbstractHttpHandler.getHttpMethods(method);
            Assertions.checkBool(httpMethods.size() >= 1, "No HttpMethod found for method: " + method.getName());
            log.info("registering " + httpMethods + " on " + absolutePath);
            HttpResourceModel resourceModel = new HttpResourceModel(httpMethods, absolutePath, method);
            log.trace("Adding resource model {}", (Object)resourceModel);
            this.patternRouter.add(absolutePath, resourceModel);
        }
    }

    public final void handle(InputStream inputStream, OutputStream outputStream) {
        HttpRequest request;
        MapResult.SimpleMapResult event = BaseSerializer.deserialize(inputStream, MapResult.SimpleMapResult.class);
        boolean isLoadBalanced = NullUtil.nonNull(event.deepRetrieve("requestContext.elb"), false);
        try {
            request = HttpRequest.from(event);
        }
        catch (Exception ex) {
            GatewayResponse.sendError(isLoadBalanced, outputStream, ex);
            return;
        }
        try {
            List<PathRouter.RoutableDestination<HttpResourceModel>> routableDestinations = this.patternRouter.getDestinations(request.uriPath);
            if (routableDestinations.isEmpty()) {
                throw WebException.notFoundException(request.uriPath);
            }
            PathRouter.RoutableDestination<HttpResourceModel> matchedDestination = this.getMatchedDestination(routableDestinations, request.method, request.uriPath);
            if (matchedDestination == null) {
                throw WebException.methodNotAllowedException(request.uriPath + ": Method Not Allowed");
            }
            HttpResourceModel httpResourceModel = (HttpResourceModel)matchedDestination.destination;
            httpResourceModel.handle(this, request, new HttpResponder(isLoadBalanced, outputStream), matchedDestination.groupNameValues);
        }
        catch (Exception ex) {
            GatewayResponse.sendError(isLoadBalanced, outputStream, ex);
        }
    }

    private PathRouter.RoutableDestination<HttpResourceModel> getMatchedDestination(List<PathRouter.RoutableDestination<HttpResourceModel>> routableDestinations, HttpMethod targetHttpMethod, String requestUri) {
        Iterable requestUriParts = SPLITTER.split((CharSequence)requestUri);
        ArrayList matchedDestinations = Lists.newArrayListWithExpectedSize((int)routableDestinations.size());
        long maxScore = 0L;
        for (PathRouter.RoutableDestination<HttpResourceModel> destination : routableDestinations) {
            HttpResourceModel resourceModel = (HttpResourceModel)destination.destination;
            for (HttpMethod httpMethod : resourceModel.httpMethods()) {
                if (!targetHttpMethod.equals((Object)httpMethod)) continue;
                long score = AbstractHttpHandler.getWeightedMatchScore(requestUriParts, SPLITTER.split((CharSequence)resourceModel.path()));
                log.trace("Max score = {}. Weighted score for {} is {}. ", new Object[]{maxScore, destination, score});
                if (score > maxScore) {
                    maxScore = score;
                    matchedDestinations.clear();
                    matchedDestinations.add(destination);
                    continue;
                }
                if (score != maxScore) continue;
                matchedDestinations.add(destination);
            }
        }
        if (matchedDestinations.size() > 1) {
            throw new IllegalStateException("Multiple matched handlers found for request uri " + requestUri + ": " + matchedDestinations);
        }
        return matchedDestinations.size() == 1 ? (PathRouter.RoutableDestination)matchedDestinations.get(0) : null;
    }

    private static long getWeightedMatchScore(Iterable<String> requestUriParts, Iterable<String> destUriParts) {
        long score = 0L;
        Iterator<String> rit = requestUriParts.iterator();
        Iterator<String> dit = destUriParts.iterator();
        while (rit.hasNext() && dit.hasNext()) {
            String destPart;
            String requestPart = rit.next();
            if (requestPart.equals(destPart = dit.next())) {
                score = score * 5L + 4L;
                continue;
            }
            if (PathRouter.GROUP_PATTERN.matcher(destPart).matches()) {
                score = score * 5L + 3L;
                continue;
            }
            score = score * 5L + 2L;
        }
        return score;
    }

    private static Set<HttpMethod> getHttpMethods(Method method) {
        HashSet httpMethods = Sets.newHashSet();
        if (method.isAnnotationPresent(GET.class)) {
            httpMethods.add(HttpMethod.GET);
        }
        if (method.isAnnotationPresent(PUT.class)) {
            httpMethods.add(HttpMethod.PUT);
        }
        if (method.isAnnotationPresent(POST.class)) {
            httpMethods.add(HttpMethod.POST);
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            httpMethods.add(HttpMethod.DELETE);
        }
        return ListBuilder.immutableSet(httpMethods);
    }
}

