/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.Serializers;
import io.polyglotted.common.util.MapRetriever;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class BaseSerializer {
    public static final ObjectMapper MAPPER = BaseSerializer.configureMapper(new ObjectMapper().registerModule((Module)new GuavaModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new ParameterNamesModule()));
    public static final JsonFactory FACTORY = new JsonFactory((ObjectCodec)MAPPER);

    public static ObjectMapper configureMapper(ObjectMapper objectMapper) {
        return objectMapper.registerModule((Module)Serializers.baseModule()).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY));
    }

    public static byte[] serializeBytes(Object object) {
        return MAPPER.writeValueAsBytes(object);
    }

    public static String serialize(Object object) {
        return MAPPER.writeValueAsString(object);
    }

    public static String prettyPrint(Object object) {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    public static <T> T deserialize(String json, Class<T> clazz) {
        return (T)MAPPER.readValue(json, clazz);
    }

    public static <T> T deserialize(String json, TypeReference<T> ref) {
        return (T)MAPPER.readValue(json, ref);
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        return (T)MAPPER.readValue(bytes, clazz);
    }

    public static <T> T deserialize(byte[] bytes, TypeReference<T> ref) {
        return (T)MAPPER.readValue(bytes, ref);
    }

    public static <T> T deserialize(InputStream stream, Class<T> clazz) {
        return (T)MAPPER.readValue(stream, clazz);
    }

    public static <T> T deserialize(InputStream stream, TypeReference<T> ref) {
        return (T)MAPPER.readValue(stream, ref);
    }

    public static <T> T deserialize(Reader reader, Class<T> clazz) {
        return (T)MAPPER.readValue(reader, clazz);
    }

    public static <T> T deserialize(Reader reader, TypeReference<T> ref) {
        return (T)MAPPER.readValue(reader, ref);
    }

    public static List<Map<String, Object>> deserializeToList(byte[] bytes) {
        return (List)MAPPER.readValue(bytes, MapRetriever.MAP_LIST_CLASS);
    }

    public static List<Map<String, Object>> deserializeToList(String json) {
        return (List)MAPPER.readValue(json, MapRetriever.MAP_LIST_CLASS);
    }

    public static List<Map<String, Object>> deserializeToList(InputStream stream) {
        return (List)MAPPER.readValue(stream, MapRetriever.MAP_LIST_CLASS);
    }

    public static List<Map<String, Object>> deserializeToList(Reader reader) {
        return (List)MAPPER.readValue(reader, MapRetriever.MAP_LIST_CLASS);
    }

    public static MapResult deserialize(byte[] bytes) {
        return (MapResult)MAPPER.readValue(bytes, MapResult.SimpleMapResult.class);
    }

    public static MapResult deserialize(String json) {
        return (MapResult)MAPPER.readValue(json, MapResult.SimpleMapResult.class);
    }

    public static void writeNotEmptyMap(JsonGenerator gen, String name, Map<?, ?> map) throws IOException {
        if (!map.isEmpty()) {
            gen.writeObjectField(name, map);
        }
    }

    public static void writeNotEmptyColl(JsonGenerator gen, String name, Collection<?> coll) throws IOException {
        if (!coll.isEmpty()) {
            gen.writeObjectField(name, coll);
        }
    }

    public static void writeNotNull(JsonGenerator gen, String name, Object obj) throws IOException {
        if (obj != null) {
            gen.writeObjectField(name, obj);
        }
    }

    public static void writeNotNullOrEmpty(JsonGenerator gen, String name, Object obj) throws IOException {
        if (obj instanceof Map) {
            BaseSerializer.writeNotEmptyMap(gen, name, (Map)obj);
        } else if (obj instanceof Collection) {
            BaseSerializer.writeNotEmptyColl(gen, name, (Collection)obj);
        } else if (obj != null) {
            gen.writeObjectField(name, obj);
        }
    }
}

