/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.ReflectionUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class EnumCache {
    private static final ConcurrentMap<Class<?>, MapResult> enumValuesMap = new ConcurrentHashMap();

    public static <E extends Enum> E fetchEnumFor(Class<E> enumClass, String value) {
        return (E)((Enum)EnumCache.fetchEnumValueFor(enumClass, value));
    }

    public static Object fetchEnumValueFor(Class enumClass, String value) {
        if (!enumValuesMap.containsKey(enumClass)) {
            EnumCache.putEnumValuesInMap(enumClass);
        }
        return ((MapResult)enumValuesMap.get(enumClass)).get(value);
    }

    private static <E extends Enum> void putEnumValuesInMap(Class<E> enumClass) {
        Assertions.checkBool(ReflectionUtil.isEnum(enumClass), enumClass + " not an enum class");
        MapBuilder.ImmutableMapBuilder values = MapBuilder.immutableMapBuilder();
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            values.put(value.name(), value);
            if (value.toString().equals(value.name())) continue;
            values.put(value.toString(), value);
        }
        enumValuesMap.putIfAbsent(enumClass, values.result());
    }
}

