/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.StrUtil;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;

public abstract class EncodingUtil {
    public static String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static byte[] decodeBase64(String value) {
        return Base64.getDecoder().decode(value);
    }

    public static String urlEncode(String path) {
        return URLEncoder.encode(path, "utf-8");
    }

    public static String urlDecode(String path) {
        return URLDecoder.decode(path, "utf-8");
    }

    public static String uriEncode(String uri, String path) {
        return StrUtil.safeSuffix(URI.create(uri).normalize().getPath(), path);
    }

    public static Pair<String, String> uriSuffixPair(String uri, String path) {
        String fullSuffix = EncodingUtil.uriEncode(uri, path);
        return Pair.pair(StrUtil.safePrefix(fullSuffix, "/"), StrUtil.safeSuffix(fullSuffix, "/"));
    }
}

