/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.model.HasMeta;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.Sanitizer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Map;

public interface Builder<T> {
    public T build();

    public static <T, C extends Builder<T>> T buildWith(Map<String, Object> result, Class<C> clazz) {
        return Builder.buildWith(result, clazz, false);
    }

    public static <T, C extends Builder<T>> T buildWith(Map<String, Object> result, Class<C> clazz, boolean inclMeta) {
        return Builder.buildWith(result, (Builder)ReflectionUtil.create(clazz), inclMeta);
    }

    public static <T, C extends Builder<T>> T buildWith(Map<String, Object> result, C builder) {
        return Builder.buildWith(result, builder, false);
    }

    public static <T, C extends Builder<T>> T buildWith(Map<String, Object> result, C builder, boolean inclMeta) {
        T built = Builder.builder(result, builder.getClass(), builder).build();
        return inclMeta && built instanceof HasMeta ? ((HasMeta)built).withMetas(result) : built;
    }

    public static <T, C extends Builder<T>> C builder(Map<String, Object> result, Class<C> clazz) {
        return (C)Builder.builder(result, clazz, (Builder)ReflectionUtil.create(clazz));
    }

    public static <T, C extends Builder<T>> C builder(Map<String, Object> result, Class<C> clazz, C builder) {
        for (Field field : clazz.getDeclaredFields()) {
            Object value = result.get(field.getName());
            if (value == null) {
                value = result.get(NullUtil.nonNullFn(ReflectionUtil.annotation(field, Name.class), Name::value, "_$"));
            }
            if (value == null) continue;
            Class<?> valueClass = ReflectionUtil.detectValueClass(value, () -> ReflectionUtil.declaredField(clazz, field.getName()));
            try {
                ReflectionUtil.safeInvoke(ReflectionUtil.declaredMethod(clazz, field.getName(), new Class[]{valueClass}), builder, Sanitizer.sanitize(valueClass, value));
            }
            catch (Exception ex) {
                throw new RuntimeException("failed invoke " + field.getName(), ex);
            }
        }
        return builder;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Name {
        public String value();
    }
}

