/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.StrUtil;

public abstract class UrnUtil {
    private static final String COLON = ":";
    private static final Joiner COLON_JOINER = Joiner.on((String)":").skipNulls();
    private static final Splitter COLON_SPLITTER = Splitter.on((String)":");

    public static String urnOf(String a, String b) {
        return StrUtil.notNullOrEmpty(a) ? (StrUtil.notNullOrEmpty(b) ? a + COLON + b : a) : (StrUtil.notNullOrEmpty(b) ? b : "");
    }

    public static String safeUrnOf(Object ... parts) {
        return COLON_JOINER.join(parts);
    }

    public static Pair<String, String> urnSplit(String urn) {
        return Pair.pair(StrUtil.safePrefix(urn, COLON), StrUtil.safeSuffix(urn, COLON));
    }

    public static String first(String urn) {
        return NullUtil.nonNull(urn, "").contains(COLON) ? (String)Iterables.getFirst((Iterable)COLON_SPLITTER.split((CharSequence)urn), null) : "";
    }
}

