/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.collect.ImmutableMap;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.ReflectionUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface MapBuilder<K, V, M extends Map<K, V>> {
    public MapBuilder<K, V, M> put(K var1, V var2);

    public MapBuilder<K, V, M> putList(K var1, List<?> var2);

    public MapBuilder<K, V, M> putAll(Map<K, V> var1);

    public int size();

    public M build();

    public MapResult result();

    public MapResult.ImmutableResult immutable();

    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder() {
        return MapBuilder.immutableMapBuilder(ImmutableMap::builder);
    }

    public static <K, V> ImmutableMapBuilder<K, V> immutableMapBuilder(Supplier<ImmutableMap.Builder<K, V>> s) {
        return new ImmutableMapBuilder(s.get());
    }

    public static <K, V> ImmutableMap<K, V> immutableMap() {
        return ImmutableMap.of();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1) {
        return ((ImmutableMapBuilder)MapBuilder.immutableMapBuilder().put((Object)k1, (Object)v1)).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2) {
        return ((ImmutableMapBuilder)((ImmutableMapBuilder)MapBuilder.immutableMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ((ImmutableMapBuilder)((ImmutableMapBuilder)((ImmutableMapBuilder)MapBuilder.immutableMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ((ImmutableMapBuilder)((ImmutableMapBuilder)((ImmutableMapBuilder)((ImmutableMapBuilder)MapBuilder.immutableMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ((ImmutableMapBuilder)((ImmutableMapBuilder)((ImmutableMapBuilder)((ImmutableMapBuilder)((ImmutableMapBuilder)MapBuilder.immutableMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).put((Object)k5, (Object)v5)).build();
    }

    public static <K, V> ImmutableMap<K, V> immutableMap(Map<K, V> map) {
        return ((ImmutableMapBuilder)MapBuilder.immutableMapBuilder().putAll((Map)map)).build();
    }

    public static <K, V> SimpleMapBuilder<K, V> simpleMapBuilder() {
        return MapBuilder.simpleMapBuilder(LinkedHashMap::new);
    }

    public static <K, V> SimpleMapBuilder<K, V> simpleMapBuilder(Supplier<Map<K, V>> supplier) {
        return new SimpleMapBuilder(supplier.get());
    }

    public static <K, V> Map<K, V> simpleMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1) {
        return ((SimpleMapBuilder)MapBuilder.simpleMapBuilder().put((Object)k1, (Object)v1)).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2) {
        return ((SimpleMapBuilder)((SimpleMapBuilder)MapBuilder.simpleMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ((SimpleMapBuilder)((SimpleMapBuilder)((SimpleMapBuilder)MapBuilder.simpleMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ((SimpleMapBuilder)((SimpleMapBuilder)((SimpleMapBuilder)((SimpleMapBuilder)MapBuilder.simpleMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).build();
    }

    public static <K, V> Map<K, V> simpleMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ((SimpleMapBuilder)((SimpleMapBuilder)((SimpleMapBuilder)((SimpleMapBuilder)((SimpleMapBuilder)MapBuilder.simpleMapBuilder().put((Object)k1, (Object)v1)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).put((Object)k5, (Object)v5)).build();
    }

    public static <K, V> Map<K, V> simpleMap(Map<K, V> map) {
        return ((SimpleMapBuilder)MapBuilder.simpleMapBuilder().putAll((Map)map)).build();
    }

    public static class SimpleMapBuilder<K, V>
    implements MapBuilder<K, V, Map<K, V>> {
        private final Map<K, V> builder;

        public SimpleMapBuilder<K, V> put(K key, V value) {
            if (value != null) {
                this.builder.put(key, value);
            }
            return this;
        }

        public SimpleMapBuilder<K, V> putList(K key, List<?> values) {
            if (values != null && !values.isEmpty()) {
                this.builder.put(key, values);
            }
            return this;
        }

        public SimpleMapBuilder<K, V> putAll(Map<K, V> map) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put((Object)e.getKey(), (Object)e.getValue());
            }
            return this;
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Override
        public Map<K, V> build() {
            return this.builder;
        }

        @Override
        public MapResult result() {
            return this.builder instanceof MapResult ? (MapResult)this.builder : new MapResult.SimpleMapResult(this.builder);
        }

        @Override
        public MapResult.ImmutableResult immutable() {
            return new MapResult.ImmutableMapResult((ImmutableMap<String, Object>)ImmutableMap.copyOf(this.builder));
        }

        private SimpleMapBuilder(Map<K, V> builder) {
            this.builder = builder;
        }
    }

    public static class ImmutableMapBuilder<K, V>
    implements MapBuilder<K, V, ImmutableMap<K, V>> {
        private final ImmutableMap.Builder<K, V> builder;

        public ImmutableMapBuilder<K, V> put(K key, V value) {
            if (value != null) {
                this.builder.put(key, value);
            }
            return this;
        }

        public ImmutableMapBuilder<K, V> putList(K key, List<?> values) {
            if (values != null && !values.isEmpty()) {
                this.builder.put(key, values);
            }
            return this;
        }

        public ImmutableMapBuilder<K, V> putAll(Map<K, V> map) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put((Object)e.getKey(), (Object)e.getValue());
            }
            return this;
        }

        @Override
        public int size() {
            return (Integer)ReflectionUtil.fieldValue(this.builder, "size");
        }

        @Override
        public ImmutableMap<K, V> build() {
            return this.builder.build();
        }

        @Override
        public MapResult result() {
            return this.immutable();
        }

        @Override
        public MapResult.ImmutableResult immutable() {
            return new MapResult.ImmutableMapResult((ImmutableMap<String, Object>)this.builder.build());
        }

        private ImmutableMapBuilder(ImmutableMap.Builder<K, V> builder) {
            this.builder = builder;
        }
    }
}

