/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.regex.Pattern;

public abstract class DateFormatters {
    private static final Pattern NUMBER = Pattern.compile("\\d*");
    private static final String[] DATE_TIME_FORMATS = new String[]{"yyyyMMdd'T'HHmm[ss]", "yyyyMMdd[ HHmm[ss]]", "yyyy-MM-dd[ HH:mm[:ss]]", "yyyy/MM/dd[ HH:mm[:ss]]", "MM/dd/yyyy[ HH:mm[:ss]]", "dd-MM-yyyy[ HH:mm[:ss]]", "dd MM yyyy[ HH:mm[:ss]]", "dd MMM yyyy[ HH:mm[:ss]]", "dd MMMM yyyy[ HH:mm[:ss]]"};
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateFormatters.createDateTimeFormatter();

    public static LocalDate parseDate(String text) {
        return NUMBER.matcher(text).matches() ? DateFormatters.toInst(text).atOffset(ZoneOffset.UTC).toLocalDate() : DATE_TIME_FORMATTER.parse((CharSequence)text, LocalDate::from);
    }

    public static LocalTime parseTime(String text) {
        return LocalTime.parse(text, DateTimeFormatter.ISO_TIME);
    }

    public static ZonedDateTime parseDateTime(String text) {
        if (NUMBER.matcher(text).matches()) {
            return ZonedDateTime.ofInstant(DateFormatters.toInst(text), ZoneOffset.UTC);
        }
        TemporalAccessor parse = DATE_TIME_FORMATTER.parse(text);
        return parse.query(TemporalQueries.zone()) != null ? parse.query(ZonedDateTime::from) : (parse.query(TemporalQueries.localTime()) != null ? parse.query(LocalDateTime::from).atZone(ZoneOffset.UTC) : parse.query(LocalDate::from).atTime(0, 0).atZone(ZoneOffset.UTC));
    }

    public static String maybeParseDateTime(Object value) {
        try {
            return DateFormatters.timeValueOf(DATE_TIME_FORMATTER.parseBest(String.valueOf(value), ZonedDateTime::from, LocalDateTime::from, LocalDate::from));
        }
        catch (Exception ex) {
            return DateFormatters.timeValueOf(value);
        }
    }

    private static String timeValueOf(Object accessor) {
        if (accessor instanceof ZonedDateTime) {
            return String.valueOf(((ZonedDateTime)accessor).toInstant().toEpochMilli());
        }
        if (accessor instanceof LocalDateTime) {
            return String.valueOf(((LocalDateTime)accessor).toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (accessor instanceof LocalDate) {
            return String.valueOf(((LocalDate)accessor).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli());
        }
        if (accessor instanceof LocalTime) {
            return String.valueOf(((LocalTime)accessor).toNanoOfDay());
        }
        return String.valueOf(accessor);
    }

    private static DateTimeFormatter createDateTimeFormatter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.optionalStart().append(DateTimeFormatter.ISO_DATE_TIME).optionalEnd();
        for (String pattern : DATE_TIME_FORMATS) {
            builder.optionalStart().appendPattern(pattern).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd();
        }
        return builder.toFormatter();
    }

    private static Instant toInst(String text) {
        return Instant.ofEpochMilli(Long.parseLong(text));
    }
}

